/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.function.SQLFunctionTemplate;

public class SQLServerDialect
extends SybaseDialect {
    public SQLServerDialect() {
        this.registerFunction("concat", new SQLFunctionTemplate(Hibernate.STRING, "(?1 + ?2)"));
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000, "varbinary($l)");
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    static int getAfterSelectInsertPoint(String sql) {
        int selectDistinctIndex = sql.indexOf("select distinct");
        if (selectDistinctIndex >= 0) {
            return selectDistinctIndex + 15;
        }
        return sql.indexOf("select") + 6;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("sql server has no offset");
        }
        return new StringBuffer(querySelect.length() + 8).append(querySelect).insert(SQLServerDialect.getAfterSelectInsertPoint(querySelect), " top " + limit).toString();
    }

    public String appendIdentitySelectToInsert(String insertSQL) {
        return insertSQL + " select scope_identity()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public char closeQuote() {
        return ']';
    }

    public char openQuote() {
        return '[';
    }

    public String appendLockHint(LockMode mode, String tableName) {
        if (mode.greaterThan(LockMode.READ)) {
            return tableName + " with (updlock, rowlock)";
        }
        return tableName;
    }

    public String getSelectGUIDString() {
        return "select newid()";
    }
}

