/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ReplicationMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public final class Cascades {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$Cascades == null ? (class$org$hibernate$engine$Cascades = Cascades.class$("org.hibernate.engine.Cascades")) : class$org$hibernate$engine$Cascades));
    public static final CascadingAction ACTION_DELETE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to delete: " + entityName));
            }
            if (ForeignKeys.isNotTransient(entityName, child, null, session)) {
                session.delete(entityName, child, isCascadeDeleteEnabled);
            }
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getAllElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    public static final CascadingAction ACTION_LOCK = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to lock: " + entityName));
            }
            session.lock(entityName, child, LockMode.NONE);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction ACTION_REFRESH = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to refresh: " + entityName));
            }
            session.refresh(child);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction ACTION_EVICT = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to evict: " + entityName));
            }
            session.evict(child);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction ACTION_SAVE_UPDATE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdate: " + entityName));
            }
            session.saveOrUpdate(entityName, child);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE";
        }
    };
    public static final CascadingAction ACTION_MERGE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to merge: " + entityName));
            }
            session.merge(entityName, child, (Map)anything);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction ACTION_SAVE_UPDATE_COPY = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to saveOrUpdateCopy: " + entityName));
            }
            session.saveOrUpdateCopy(entityName, child, (Map)anything);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE_COPY";
        }
    };
    public static final CascadingAction ACTION_PERSIST = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to persist: " + entityName));
            }
            session.persist(entityName, child, (Map)anything);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getAllElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction ACTION_REPLICATE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascading to replicate: " + entityName));
            }
            session.replicate(child, (ReplicationMode)anything);
        }

        Iterator getCascadableChildrenIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(session, collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int CASCADE_BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int CASCADE_AFTER_UPDATE = 0;
    public static final int CASCADE_BEFORE_FLUSH = 0;
    public static final int CASCADE_AFTER_EVICT = 0;
    public static final int CASCADE_AFTER_REFRESH = 0;
    public static final int CASCADE_AFTER_LOCK = 0;
    public static final int CASCADE_BEFORE_MERGE = 0;
    public static final CascadeStyle STYLE_ALL_DELETE_ORPHAN = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return true;
        }

        boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_ALL_DELETE_ORPHAN";
        }
    };
    public static final CascadeStyle STYLE_ALL = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return true;
        }

        public String toString() {
            return "STYLE_ALL";
        }
    };
    public static final CascadeStyle STYLE_SAVE_UPDATE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_SAVE_UPDATE || action == ACTION_SAVE_UPDATE_COPY;
        }

        public String toString() {
            return "STYLE_SAVE_UPDATE";
        }
    };
    public static final CascadeStyle STYLE_LOCK = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_LOCK;
        }

        public String toString() {
            return "STYLE_LOCK";
        }
    };
    public static final CascadeStyle STYLE_REFRESH = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_REFRESH;
        }

        public String toString() {
            return "STYLE_REFRESH";
        }
    };
    public static final CascadeStyle STYLE_EVICT = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_EVICT;
        }

        public String toString() {
            return "STYLE_EVICT";
        }
    };
    public static final CascadeStyle STYLE_REPLICATE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_REPLICATE;
        }

        public String toString() {
            return "STYLE_REPLICATE";
        }
    };
    public static final CascadeStyle STYLE_MERGE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_MERGE;
        }

        public String toString() {
            return "STYLE_MERGE";
        }
    };
    public static final CascadeStyle STYLE_PERSIST = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_PERSIST;
        }

        public String toString() {
            return "STYLE_PERSIST";
        }
    };
    public static final CascadeStyle STYLE_DELETE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_DELETE;
        }

        public String toString() {
            return "STYLE_DELETE";
        }
    };
    public static final CascadeStyle STYLE_DELETE_ORPHAN = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_DELETE || action == ACTION_SAVE_UPDATE;
        }

        boolean reallyDoCascade(CascadingAction action) {
            return action == ACTION_DELETE;
        }

        boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_DELETE_ORPHAN";
        }
    };
    public static final CascadeStyle STYLE_NONE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_REPLICATE;
        }

        public String toString() {
            return "STYLE_NONE";
        }
    };
    public static final IdentifierValue SAVE_ANY = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace((Object)"id unsaved-value strategy ANY");
            return Boolean.TRUE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        public String toString() {
            return "SAVE_ANY";
        }
    };
    public static final IdentifierValue SAVE_NONE = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace((Object)"id unsaved-value strategy NONE");
            return Boolean.FALSE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        public String toString() {
            return "SAVE_NONE";
        }
    };
    public static final IdentifierValue SAVE_NULL = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace((Object)"id unsaved-value strategy NULL");
            return id == null ? Boolean.TRUE : Boolean.FALSE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        public String toString() {
            return "SAVE_NULL";
        }
    };
    public static final IdentifierValue UNDEFINED = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace((Object)"id unsaved-value strategy UNDEFINED");
            return null;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        public String toString() {
            return "UNDEFINED";
        }
    };
    public static final VersionValue VERSION_SAVE_NULL = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            log.trace((Object)"version unsaved-value strategy NULL");
            return version == null ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object getDefaultValue(Object currentValue) {
            return null;
        }

        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final VersionValue VERSION_UNDEFINED = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            log.trace((Object)"version unsaved-value strategy UNDEFINED");
            return version == null ? Boolean.TRUE : null;
        }

        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final VersionValue VERSION_NEGATIVE = new VersionValue(){

        public final Boolean isUnsaved(Object version) throws MappingException {
            log.trace((Object)"version unsaved-value strategy NEGATIVE");
            if (version == null) {
                return Boolean.TRUE;
            }
            if (version instanceof Number) {
                return ((Number)version).longValue() < 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        public Object getDefaultValue(Object currentValue) {
            return IdentifierGeneratorFactory.createNumber(-1L, currentValue.getClass());
        }

        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };
    private static final Map STYLES = new HashMap();
    static /* synthetic */ Class class$org$hibernate$engine$Cascades;

    private Cascades() {
    }

    private static boolean collectionIsInitialized(Object collection) {
        return !(collection instanceof PersistentCollection) || ((PersistentCollection)collection).wasInitialized();
    }

    private static void cascade(SessionImplementor session, Object child, Type type, CascadingAction action, CascadeStyle style, int cascadeTo, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        block3: {
            block4: {
                block5: {
                    String entityName;
                    if (child == null) break block3;
                    if (!type.isAssociationType()) break block4;
                    if (!((AssociationType)type).getForeignKeyDirection().cascadeNow(cascadeTo)) break block3;
                    if (!type.isEntityType() && !type.isAnyType()) break block5;
                    String string = entityName = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
                    if (style.reallyDoCascade(action)) {
                        action.cascade(session, child, entityName, anything, isCascadeDeleteEnabled);
                    }
                    break block3;
                }
                if (!type.isCollectionType()) break block3;
                int cascadeVia = cascadeTo == 1 ? 3 : cascadeTo;
                CollectionType pctype = (CollectionType)type;
                CollectionPersister persister = session.getFactory().getCollectionPersister(pctype.getRole());
                Type elemType = persister.getElementType();
                if (!elemType.isEntityType() && !elemType.isAnyType() && !elemType.isComponentType()) break block3;
                Cascades.cascadeCollection(action, style, pctype, elemType, child, cascadeVia, session, anything, persister.isCascadeDeleteEnabled());
                break block3;
            }
            if (type.isComponentType()) {
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] children = componentType.getPropertyValues(child, session);
                Type[] types = componentType.getSubtypes();
                for (int i = 0; i < types.length; ++i) {
                    CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
                    if (!componentPropertyStyle.doCascade(action)) continue;
                    Cascades.cascade(session, children[i], types[i], action, componentPropertyStyle, cascadeTo, anything, false);
                }
            }
        }
    }

    public static void cascade(SessionImplementor session, EntityPersister persister, Object parent, CascadingAction action, int cascadeTo) throws HibernateException {
        Cascades.cascade(session, persister, parent, action, cascadeTo, null);
    }

    public static void cascade(SessionImplementor session, EntityPersister persister, Object parent, CascadingAction action, int cascadeTo, Object anything) throws HibernateException {
        if (persister.hasCascades()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing cascade " + action + " for: " + persister.getEntityName()));
            }
            Type[] types = persister.getPropertyTypes();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            for (int i = 0; i < types.length; ++i) {
                CascadeStyle style = cascadeStyles[i];
                if (!style.doCascade(action)) continue;
                Cascades.cascade(session, persister.getPropertyValue(parent, i, session.getEntityMode()), types[i], action, style, cascadeTo, anything, false);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done processing cascade " + action + " for: " + persister.getEntityName()));
            }
        }
    }

    private static void cascadeCollection(CascadingAction action, CascadeStyle style, CollectionType collectionType, Type elemType, Object child, int cascadeVia, SessionImplementor session, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean deleteOrphans;
        if (child == CollectionType.UNFETCHED_COLLECTION) {
            return;
        }
        if (style.reallyDoCascade(action)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("cascade " + action + " for collection: " + collectionType.getRole()));
            }
            Iterator iter = action.getCascadableChildrenIterator(session, collectionType, child);
            while (iter.hasNext()) {
                Cascades.cascade(session, iter.next(), elemType, action, style, cascadeVia, anything, isCascadeDeleteEnabled);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("done cascade " + action + " for collection: " + collectionType.getRole()));
            }
        }
        boolean bl = deleteOrphans = style.hasOrphanDelete() && action.deleteOrphans() && elemType.isEntityType() && child instanceof PersistentCollection;
        if (deleteOrphans) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleting orphans for collection: " + collectionType.getRole()));
            }
            String entityName = collectionType.getAssociatedEntityName(session.getFactory());
            Cascades.deleteOrphans(entityName, (PersistentCollection)child, session);
            if (log.isTraceEnabled()) {
                log.trace((Object)("done deleting orphans for collection: " + collectionType.getRole()));
            }
        }
    }

    private static void deleteOrphans(String entityName, PersistentCollection pc, SessionImplementor session) throws HibernateException {
        CollectionEntry ce;
        if (pc.wasInitialized() && (ce = session.getPersistenceContext().getCollectionEntry(pc)) != null) {
            Iterator orphanIter = ce.getOrphans(entityName, pc).iterator();
            while (orphanIter.hasNext()) {
                Object orphan = orphanIter.next();
                if (orphan == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("deleting orphaned: " + entityName));
                }
                session.delete(entityName, orphan, false);
            }
        }
    }

    public static Iterator getLoadedElementsIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
        if (Cascades.collectionIsInitialized(collection)) {
            return collectionType.getElementsIterator(collection, session);
        }
        return ((PersistentCollection)collection).queuedAdditionIterator();
    }

    private static Iterator getAllElementsIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
        return collectionType.getElementsIterator(collection, session);
    }

    public static CascadeStyle getCascadeStyle(String cascade) {
        CascadeStyle style = (CascadeStyle)STYLES.get(cascade);
        if (style == null) {
            throw new MappingException("Unsupported cascade style: " + cascade);
        }
        return style;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        STYLES.put("all", STYLE_ALL);
        STYLES.put("all-delete-orphan", STYLE_ALL_DELETE_ORPHAN);
        STYLES.put("save-update", STYLE_SAVE_UPDATE);
        STYLES.put("persist", STYLE_PERSIST);
        STYLES.put("merge", STYLE_MERGE);
        STYLES.put("lock", STYLE_LOCK);
        STYLES.put("refresh", STYLE_REFRESH);
        STYLES.put("replicate", STYLE_REPLICATE);
        STYLES.put("evict", STYLE_EVICT);
        STYLES.put("delete", STYLE_DELETE);
        STYLES.put("delete-orphan", STYLE_DELETE_ORPHAN);
        STYLES.put("none", STYLE_NONE);
    }

    public static class VersionValue {
        private final Object value;

        protected VersionValue() {
            this.value = null;
        }

        public VersionValue(Object value) {
            this.value = value;
        }

        public Boolean isUnsaved(Object version) throws MappingException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("version unsaved-value: " + this.value));
            }
            return version == null || version.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object getDefaultValue(Object currentValue) {
            return this.value;
        }

        public String toString() {
            return "version unsaved-value: " + this.value;
        }
    }

    public static class IdentifierValue {
        private final Serializable value;

        protected IdentifierValue() {
            this.value = null;
        }

        public IdentifierValue(Serializable value) {
            this.value = value;
        }

        public Boolean isUnsaved(Serializable id) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("id unsaved-value: " + this.value));
            }
            return id == null || id.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return this.value;
        }

        public String toString() {
            return "identifier unsaved-value: " + this.value;
        }
    }

    public static final class MultipleCascadeStyle
    extends CascadeStyle {
        private final CascadeStyle[] styles;

        public MultipleCascadeStyle(CascadeStyle[] styles) {
            this.styles = styles;
        }

        boolean doCascade(CascadingAction action) {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].doCascade(action)) continue;
                return true;
            }
            return false;
        }

        boolean reallyDoCascade(CascadingAction action) {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].reallyDoCascade(action)) continue;
                return true;
            }
            return false;
        }

        boolean hasOrphanDelete() {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].hasOrphanDelete()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return ArrayHelper.toString(this.styles);
        }
    }

    public static abstract class CascadeStyle
    implements Serializable {
        protected CascadeStyle() {
        }

        abstract boolean doCascade(CascadingAction var1);

        boolean reallyDoCascade(CascadingAction action) {
            return this.doCascade(action);
        }

        boolean hasOrphanDelete() {
            return false;
        }
    }

    public static abstract class CascadingAction {
        protected CascadingAction() {
        }

        abstract void cascade(SessionImplementor var1, Object var2, String var3, Object var4, boolean var5) throws HibernateException;

        abstract Iterator getCascadableChildrenIterator(SessionImplementor var1, CollectionType var2, Object var3);

        abstract boolean deleteOrphans();
    }
}

