/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.ReattachVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;

public class OnReplicateVisitor
extends ReattachVisitor {
    OnReplicateVisitor(SessionImplementor session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        SessionImplementor session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getFactory().getCollectionPersister(type.getRole());
        this.removeCollection(persister, key, session);
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            wrapper.setCurrentSession(session);
            if (wrapper.wasInitialized()) {
                session.getPersistenceContext().addNewCollection(wrapper, persister);
            } else {
                this.reattachCollection(wrapper, wrapper.getCollectionSnapshot());
            }
        }
        return null;
    }
}

