/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.ViolatedConstraintNameExtracter;

public class ErrorCodeConverter
implements SQLExceptionConverter {
    private ViolatedConstraintNameExtracter extracter;

    public ErrorCodeConverter(ViolatedConstraintNameExtracter extracter) {
        this.extracter = extracter;
    }

    protected int[] getSQLGrammarErrorCodes() {
        return null;
    }

    protected int[] getConnectionErrorCodes() {
        return null;
    }

    protected int[] getIntegrityViolationErrorCodes() {
        return null;
    }

    protected int[] getLockAcquisitionErrorCodes() {
        return null;
    }

    public JDBCException convert(SQLException sqlException, String message, String sql) {
        int errorCode = JDBCExceptionHelper.extractErrorCode(sqlException);
        if (this.isMatch(this.getConnectionErrorCodes(), errorCode)) {
            return new JDBCConnectionException(message, sqlException, sql);
        }
        if (this.isMatch(this.getSQLGrammarErrorCodes(), errorCode)) {
            return new SQLGrammarException(message, sqlException, sql);
        }
        if (this.isMatch(this.getIntegrityViolationErrorCodes(), errorCode)) {
            String constraintName = this.extracter.extractConstraintName(sqlException);
            return new ConstraintViolationException(message, sqlException, constraintName, sql);
        }
        if (this.isMatch(this.getLockAcquisitionErrorCodes(), errorCode)) {
            return new LockAcquisitionException(message, sqlException, sql);
        }
        return this.handledNonSpecificException(sqlException, message, sql);
    }

    protected JDBCException handledNonSpecificException(SQLException sqlException, String message, String sql) {
        return new GenericJDBCException(message, sqlException, sql);
    }

    private boolean isMatch(int[] errorCodes, int errorCode) {
        if (errorCodes != null) {
            int max = errorCodes.length;
            for (int i = 0; i < max; ++i) {
                if (errorCodes[i] != errorCode) continue;
                return true;
            }
        }
        return false;
    }
}

