/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.SqlNode;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

class SessionFactoryHelper {
    private SessionFactoryImplementor sfi;
    private Map collectionPropertyMappingByRole;

    SessionFactoryHelper(SessionFactoryImplementor sfi) {
        this.sfi = sfi;
        this.collectionPropertyMappingByRole = new HashMap();
    }

    String getImportedClassName(String className) {
        return this.sfi.getImportedClassName(className);
    }

    Queryable findQueryableUsingImports(String className) {
        String importedClassName = this.sfi.getImportedClassName(className);
        if (importedClassName == null) {
            return null;
        }
        try {
            return (Queryable)this.sfi.getEntityPersister(importedClassName);
        }
        catch (MappingException me) {
            return null;
        }
    }

    private EntityPersister findEntityPersisterByName(String className) throws MappingException {
        EntityPersister persister = null;
        try {
            persister = this.sfi.getEntityPersister(className);
        }
        catch (MappingException ignore) {
            // empty catch block
        }
        if (persister == null) {
            String importedClassName = this.sfi.getImportedClassName(className);
            if (importedClassName == null) {
                return null;
            }
            persister = this.sfi.getEntityPersister(importedClassName);
        }
        return persister;
    }

    EntityPersister requireClassPersister(String className) throws SemanticException {
        EntityPersister cp;
        try {
            cp = this.findEntityPersisterByName(className);
            if (cp == null) {
                throw new SemanticException(className + " is not mapped.");
            }
        }
        catch (MappingException e) {
            throw new DetailedSemanticException(e.getMessage(), e);
        }
        return cp;
    }

    QueryableCollection requireQueryableCollection(String role) {
        try {
            QueryableCollection queryableCollection = (QueryableCollection)this.sfi.getCollectionPersister(role);
            if (queryableCollection != null) {
                this.collectionPropertyMappingByRole.put(role, new CollectionPropertyMapping(queryableCollection));
            }
            return queryableCollection;
        }
        catch (ClassCastException cce) {
            throw new QueryException("collection role is not queryable: " + role);
        }
        catch (Exception e) {
            throw new QueryException("collection role not found: " + role);
        }
    }

    private PropertyMapping getCollectionPropertyMapping(String role) {
        return (PropertyMapping)this.collectionPropertyMappingByRole.get(role);
    }

    String[] getCollectionElementColumns(String role, String roleAlias) {
        return this.getCollectionPropertyMapping(role).toColumns(roleAlias, "elements");
    }

    JoinSequence createJoinSequence() {
        return new JoinSequence(this.sfi);
    }

    JoinSequence createJoinSequence(boolean implicit, AssociationType associationType, String tableAlias, int joinType, String[] columns) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setUseThetaStyle(implicit);
        joinSequence.addJoin(associationType, tableAlias, joinType, columns);
        return joinSequence;
    }

    JoinSequence createCollectionJoinSequence(QueryableCollection collPersister, String collectionName) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setRoot(collPersister, collectionName);
        joinSequence.setUseThetaStyle(true);
        return joinSequence;
    }

    String getIdentifierOrUniqueKeyPropertyName(EntityType entityType) {
        try {
            return entityType.getIdentifierOrUniqueKeyPropertyName(this.sfi);
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
    }

    int getColumnSpan(Type type) {
        return type.getColumnSpan(this.sfi);
    }

    String getAssociatedEntityName(CollectionType collectionType) {
        return collectionType.getAssociatedEntityName(this.sfi);
    }

    private Type getElementType(CollectionType collectionType) {
        return collectionType.getElementType(this.sfi);
    }

    public AssociationType getElementAssociationType(CollectionType collectionType) {
        return (AssociationType)this.getElementType(collectionType);
    }

    SQLFunction findSQLFunction(String functionName) {
        return (SQLFunction)this.sfi.getDialect().getFunctions().get(functionName);
    }

    private SQLFunction requireSQLFunction(String functionName) {
        SQLFunction f = this.findSQLFunction(functionName);
        if (f == null) {
            throw new QueryException("Unable to find SQL function: " + functionName);
        }
        return f;
    }

    Type findFunctionReturnType(String functionName, AST first) {
        Type argumentType = null;
        if (first != null && first instanceof SqlNode) {
            SqlNode sqlNode = (SqlNode)first;
            argumentType = sqlNode.getDataType();
        }
        Type functionReturnType = this.requireSQLFunction(functionName).getReturnType(argumentType, this.sfi);
        return functionReturnType;
    }

    public QueryableCollection getCollectionPersister(String collectionRole) {
        try {
            return (QueryableCollection)this.sfi.getCollectionPersister(collectionRole);
        }
        catch (ClassCastException cce) {
            throw new QueryException("collection collectionRole is not queryable: " + collectionRole);
        }
        catch (Exception e) {
            throw new QueryException("collection collectionRole not found: " + collectionRole);
        }
    }

    public String[][] generateColumnNames(Type[] sqlResultTypes) {
        return NameGenerator.generateColumnNames(sqlResultTypes, this.sfi);
    }
}

