/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.JoinHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;

public final class OuterJoinableAssociation {
    private final AssociationType joinableType;
    private final Joinable joinable;
    private final String alias;
    private final String[] lhsColumns;
    private final String rhsAlias;
    private final String[] rhsColumns;
    private final int joinType;
    private final String on;

    OuterJoinableAssociation(AssociationType joinableType, String alias, String[] lhsColumns, String joinedAlias, int joinType, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this.joinableType = joinableType;
        this.alias = alias;
        this.lhsColumns = lhsColumns;
        this.rhsAlias = joinedAlias;
        this.joinType = joinType;
        this.joinable = joinableType.getAssociatedJoinable(factory);
        this.rhsColumns = JoinHelper.getRHSColumnNames(joinableType, factory);
        this.on = joinableType.getOnCondition(joinedAlias, factory, enabledFilters);
    }

    public int getJoinType() {
        return this.joinType;
    }

    public String getRHSAlias() {
        return this.rhsAlias;
    }

    private boolean isOneToOne() {
        if (this.joinableType.isEntityType()) {
            EntityType etype = (EntityType)this.joinableType;
            return etype.isOneToOne();
        }
        return false;
    }

    public AssociationType getJoinableType() {
        return this.joinableType;
    }

    public String getRHSUniqueKeyName() {
        return this.joinableType.getRHSUniqueKeyPropertyName();
    }

    public boolean isCollection() {
        return this.joinableType.isCollectionType();
    }

    public Joinable getJoinable() {
        return this.joinable;
    }

    public int getOwner(List associations) {
        if (this.isOneToOne() || this.isCollection()) {
            return OuterJoinableAssociation.getPosition(this.alias, associations);
        }
        return -1;
    }

    private static int getPosition(String alias, List associations) {
        int result = 0;
        for (int i = 0; i < associations.size(); ++i) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)associations.get(i);
            if (!oj.getJoinable().consumesAlias()) continue;
            if (oj.rhsAlias.equals(alias)) {
                return result;
            }
            ++result;
        }
        return result;
    }

    public void addJoins(JoinFragment outerjoin) throws MappingException {
        outerjoin.addJoin(this.joinable.getTableName(), this.rhsAlias, this.lhsColumns, this.rhsColumns, this.joinType, this.on);
        outerjoin.addJoins(this.joinable.fromJoinFragment(this.rhsAlias, false, true), this.joinable.whereJoinFragment(this.rhsAlias, false, true));
    }

    public void validateJoin(String path) throws MappingException {
        if (this.rhsColumns == null || this.lhsColumns == null || this.lhsColumns.length != this.rhsColumns.length || this.lhsColumns.length == 0) {
            throw new MappingException("invalid join columns for association: " + path);
        }
    }
}

