/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.AbstractEntityLoader;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaLoader
extends AbstractEntityLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();

    public CriteriaLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria, String rootEntityName, Map enabledFilters) throws HibernateException {
        super(persister, factory, enabledFilters);
        this.translator = new CriteriaQueryTranslator(factory, criteria, rootEntityName, "this_");
        this.querySpaces = this.translator.getQuerySpaces();
        if (this.translator.hasProjection()) {
            this.resultTypes = this.translator.getProjectedTypes();
            this.initProjection(this.translator.getSelect(), this.translator.getWhereCondition(), this.translator.getOrderBy(), this.translator.getGroupBy(), LockMode.NONE);
        } else {
            this.resultTypes = new Type[]{Hibernate.entity(persister.getEntityName())};
            this.initAll(this.translator.getWhereCondition(), this.translator.getOrderBy(), LockMode.NONE);
        }
        this.userAliasList.add(criteria.getAlias());
        this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor session, ScrollMode scrollMode) throws HibernateException {
        QueryParameters qp = this.translator.getQueryParameters();
        qp.setScrollMode(scrollMode);
        return this.scroll(qp, this.resultTypes, null, session);
    }

    public List list(SessionImplementor session) throws HibernateException {
        return this.list(session, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        String[] aliases;
        Object[] result;
        if (this.translator.hasProjection()) {
            Type[] types = this.translator.getProjectedTypes();
            result = new Object[types.length];
            String[] columnAliases = this.translator.getProjectedColumnAliases();
            for (int i = 0; i < result.length; ++i) {
                result[i] = types[i].nullSafeGet(rs, columnAliases[i], session, null);
            }
            aliases = this.translator.getProjectedAliases();
        } else {
            result = row;
            aliases = this.userAliases;
        }
        return this.translator.getRootCriteria().getResultTransformer().transformTuple(result, aliases);
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path, Set visitedAssociations, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        if (this.translator.isJoin(path)) {
            return 0;
        }
        FetchMode fm = this.translator.getRootCriteria().getFetchMode(path);
        if (CriteriaLoader.isDefaultFetchMode(fm)) {
            return super.getJoinType(type, config, path, visitedAssociations, lhsTable, lhsColumns, nullable, currentDepth);
        }
        if (fm == FetchMode.JOIN) {
            return this.getJoinType(nullable, currentDepth);
        }
        return -1;
    }

    private static boolean isDefaultFetchMode(FetchMode fm) {
        return fm == null || fm == FetchMode.DEFAULT;
    }

    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getEnabledFilters());
    }

    protected String generateTableAlias(int n, String path, Joinable joinable) {
        if (joinable.consumesAlias()) {
            String sqlAlias;
            Criteria subcriteria = this.translator.getCriteria(path);
            String string = sqlAlias = subcriteria == null ? null : this.translator.getSQLAlias(subcriteria);
            if (sqlAlias != null) {
                this.userAliasList.add(subcriteria.getAlias());
                return sqlAlias;
            }
            this.userAliasList.add(null);
        }
        return super.generateTableAlias(n + this.translator.getSQLAliasCount(), path, joinable);
    }

    protected String generateRootAlias(String tableName) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected String applyLocks(String sqlSelectString, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sqlSelectString;
        }
        HashMap<String, String[]> keyColumnNames = null;
        Loadable[] persisters = this.getEntityPersisters();
        String[] entityAliases = this.getAliases();
        if (dialect.forUpdateOfColumns()) {
            keyColumnNames = new HashMap<String, String[]>();
            for (int i = 0; i < entityAliases.length; ++i) {
                keyColumnNames.put(entityAliases[i], persisters[i].getIdentifierColumnNames());
            }
        }
        return sqlSelectString + new ForUpdateFragment(dialect, lockModes, keyColumnNames).toFragmentString();
    }

    protected LockMode[] getLockModes(Map lockModes) {
        String[] entityAliases = this.getAliases();
        if (entityAliases == null) {
            return null;
        }
        int size = entityAliases.length;
        LockMode[] lockModesArray = new LockMode[size];
        for (int i = 0; i < size; ++i) {
            LockMode lockMode = (LockMode)lockModes.get(entityAliases[i]);
            lockModesArray[i] = lockMode == null ? LockMode.NONE : lockMode;
        }
        return lockModesArray;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    protected List getResultList(List results) {
        return this.translator.getRootCriteria().getResultTransformer().transformList(results);
    }

    public String getComment() {
        return "criteria query";
    }
}

