/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CustomLoader
extends Loader {
    private final Type[] resultTypes;
    private final Loadable[] persisters;
    private final CollectionPersister collectionPersister;
    private final CustomQuery customQuery;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(factory);
        int i;
        this.customQuery = customQuery;
        this.collectionPersister = customQuery.getCollectionRole() == null ? null : factory.getCollectionPersister(customQuery.getCollectionRole());
        String[] entityNames = customQuery.getEntityNames();
        this.persisters = new Loadable[entityNames.length];
        for (int i2 = 0; i2 < entityNames.length; ++i2) {
            this.persisters[i2] = (Loadable)factory.getEntityPersister(entityNames[i2]);
        }
        Type[] scalarTypes = customQuery.getScalarTypes();
        this.resultTypes = new Type[entityNames.length + (scalarTypes == null ? 0 : scalarTypes.length)];
        for (i = 0; i < scalarTypes.length; ++i) {
            this.resultTypes[i] = scalarTypes[i];
        }
        for (i = 0; i < entityNames.length; ++i) {
            this.resultTypes[i + scalarTypes.length] = Hibernate.entity(entityNames[i]);
        }
    }

    protected String getSQLString() {
        return this.customQuery.getSQL();
    }

    protected Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    protected LockMode[] getLockModes(Map lockModesMap) {
        return this.customQuery.getLockModes();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected int getCollectionOwner() {
        return this.customQuery.getCollectionOwner();
    }

    protected int[] getOwners() {
        return this.customQuery.getEntityOwners();
    }

    public Set getQuerySpaces() {
        return this.customQuery.getQuerySpaces();
    }

    protected String getQueryIdentifier() {
        return this.customQuery.getSQL();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.customQuery.getQuerySpaces(), this.resultTypes);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, null, session);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        Object[] resultRow;
        Type[] scalarTypes = this.customQuery.getScalarTypes();
        String[] scalarColumnAliases = this.customQuery.getScalarColumnAliases();
        if (scalarTypes != null && scalarTypes.length > 0) {
            resultRow = new Object[scalarTypes.length + row.length];
            for (int i = 0; i < scalarTypes.length; ++i) {
                resultRow[i] = scalarTypes[i].nullSafeGet(rs, scalarColumnAliases[i], session, null);
            }
            System.arraycopy(row, 0, resultRow, scalarTypes.length, row.length);
        } else {
            resultRow = row;
        }
        return resultRow.length == 1 ? resultRow[0] : resultRow;
    }

    protected EntityAliases[] getEntityAliases() {
        return this.customQuery.getEntityAliases();
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.customQuery.getNamedParameterBindPoints().get(name);
        if (loc == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name, this.customQuery.getSQL());
            throw qe;
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }
}

