/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.AbstractEntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class EntityLoader
extends AbstractEntityLoader
implements UniqueEntityLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$entity$EntityLoader == null ? (class$org$hibernate$loader$entity$EntityLoader = EntityLoader.class$("org.hibernate.loader.entity.EntityLoader")) : class$org$hibernate$loader$entity$EntityLoader));
    private final Type uniqueKeyType;
    private final boolean batchLoader;
    private final String entityName;
    private final LockMode lockMode;
    static /* synthetic */ Class class$org$hibernate$loader$entity$EntityLoader;

    public EntityLoader(OuterJoinLoadable persister, LockMode lockMode, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(persister, 1, lockMode, factory, enabledFilters);
    }

    public EntityLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(persister, persister.getIdentifierColumnNames(), persister.getIdentifierType(), batchSize, lockMode, false, factory, enabledFilters);
    }

    public EntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(persister, uniqueKey, uniqueKeyType, batchSize, lockMode, true, factory, enabledFilters);
    }

    public EntityLoader(OuterJoinLoadable persister, String[] uniqueKey, Type uniqueKeyType, int batchSize, LockMode lockMode, boolean includeFilter, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(persister, factory, enabledFilters);
        this.uniqueKeyType = uniqueKeyType;
        this.entityName = persister.getEntityName();
        this.lockMode = lockMode;
        StringBuffer whereCondition = this.whereString(this.getAlias(), uniqueKey, batchSize, null);
        if (includeFilter) {
            String filter = persister.filterFragment(this.getAlias(), enabledFilters);
            whereCondition.insert(0, StringHelper.moveAndToBeginning(filter));
        }
        this.initAll(whereCondition.toString(), "", lockMode);
        this.postInstantiate();
        this.batchLoader = batchSize > 1;
        log.debug((Object)("Static select for entity " + this.entityName + ": " + this.getSQLString()));
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        return this.load(session, id, optionalObject, id);
    }

    public Object loadByUniqueKey(SessionImplementor session, Object key) throws HibernateException {
        return this.load(session, key, null, null);
    }

    private Object load(SessionImplementor session, Object id, Object optionalObject, Serializable optionalId) throws HibernateException {
        List list = this.loadEntity(session, id, this.uniqueKeyType, optionalObject, this.entityName, optionalId, this.getPersister());
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        if (this.getCollectionOwner() > -1) {
            return list.get(0);
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.getPersister().getEntityName());
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row[row.length - 1];
    }

    protected boolean isSingleRowLoader() {
        return !this.batchLoader;
    }

    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config) {
        return this.lockMode.greaterThan(LockMode.READ) ? false : super.isJoinedFetchEnabled(type, config);
    }

    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

