/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Isolater {
    private static final Logger log = LoggerFactory.getLogger(Isolater.class);

    public static void doIsolatedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, true);
        } else {
            new JdbcDelegate(session).delegateWork(work, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, false);
        } else {
            new JdbcDelegate(session).delegateWork(work, false);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor session) {
            this.session = session;
        }

        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            boolean wasAutoCommit = false;
            try {
                Connection connection = this.session.getFactory().getConnectionProvider().getConnection();
                try {
                    if (transacted && connection.getAutoCommit()) {
                        wasAutoCommit = true;
                        connection.setAutoCommit(false);
                    }
                    work.doWork(connection);
                    if (transacted) {
                        connection.commit();
                    }
                }
                catch (Exception e) {
                    try {
                        if (transacted && !connection.isClosed()) {
                            connection.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        log.info("unable to rollback connection on exception [" + ignore + "]");
                    }
                    if (e instanceof HibernateException) {
                        throw (HibernateException)e;
                    }
                    if (e instanceof SQLException) {
                        throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), (SQLException)e, "error performing isolated work");
                    }
                    throw new HibernateException("error performing isolated work", e);
                }
                finally {
                    if (transacted && wasAutoCommit) {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Exception ignore) {
                            log.trace("was unable to reset connection back to auto-commit");
                        }
                    }
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Exception ignore) {
                        log.info("Unable to release isolated connection [" + ignore + "]");
                    }
                }
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sqle, "unable to obtain isolated JDBC connection");
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor session) {
            this.session = session;
        }

        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            try {
                Transaction surroundingTransaction = transactionManager.suspend();
                if (log.isDebugEnabled()) {
                    log.debug("surrounding JTA transaction suspended [" + surroundingTransaction + "]");
                }
                boolean hadProblems = false;
                try {
                    if (transacted) {
                        this.doTheWorkInNewTransaction(work, transactionManager);
                    } else {
                        this.doTheWorkInNoTransaction(work);
                    }
                }
                catch (HibernateException e) {
                    hadProblems = true;
                    throw e;
                }
                finally {
                    block16: {
                        try {
                            transactionManager.resume(surroundingTransaction);
                            if (log.isDebugEnabled()) {
                                log.debug("surrounding JTA transaction resumed [" + surroundingTransaction + "]");
                            }
                        }
                        catch (Throwable t) {
                            if (hadProblems) break block16;
                            throw new HibernateException("Unable to resume previously suspended transaction", t);
                        }
                    }
                }
            }
            catch (SystemException e) {
                throw new HibernateException("Unable to suspend current JTA transaction", e);
            }
        }

        private void doTheWorkInNewTransaction(IsolatedWork work, TransactionManager transactionManager) {
            try {
                transactionManager.begin();
                try {
                    this.doTheWork(work);
                    transactionManager.commit();
                }
                catch (Exception e) {
                    try {
                        transactionManager.rollback();
                    }
                    catch (Exception ignore) {
                        log.info("Unable to rollback isolated transaction on error [" + e + "] : [" + ignore + "]");
                    }
                }
            }
            catch (SystemException e) {
                throw new HibernateException("Unable to start isolated transaction", e);
            }
            catch (NotSupportedException e) {
                throw new HibernateException("Unable to start isolated transaction", e);
            }
        }

        private void doTheWorkInNoTransaction(IsolatedWork work) {
            this.doTheWork(work);
        }

        private void doTheWork(IsolatedWork work) {
            try {
                Connection connection = this.session.getFactory().getConnectionProvider().getConnection();
                try {
                    work.doWork(connection);
                }
                catch (HibernateException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to perform isolated work", e);
                }
                finally {
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Throwable ignore) {
                        log.info("Unable to release isolated connection [" + ignore + "]");
                    }
                }
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sqle, "unable to obtain isolated JDBC connection");
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }
}

