/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.HEMLogging;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutput;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToFile;
import org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToWriter;
import org.jboss.logging.Logger;

public class ScriptTargetOutputToUrl
extends ScriptTargetOutputToWriter
implements ScriptTargetOutput {
    private static final Logger log = HEMLogging.logger(ScriptTargetOutputToUrl.class);

    public ScriptTargetOutputToUrl(URL url) {
        super(ScriptTargetOutputToUrl.toWriter(url));
    }

    @Override
    public void release() {
        try {
            this.writer().close();
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to close file writer : " + e.toString());
        }
    }

    private static Writer toWriter(URL url) {
        log.debug((Object)("Attempting to resolve writer for URL : " + url));
        try {
            return ScriptTargetOutputToFile.toFileWriter(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new PersistenceException(String.format("Could not convert specified URL[%s] to a File reference", url), (Throwable)e);
        }
    }
}

