/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.internal.metadata.aggregated.rule.MethodConfigurationRule;
import org.hibernate.validator.internal.metadata.aggregated.rule.OverridingMethodMustNotAlterParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine;
import org.hibernate.validator.internal.metadata.aggregated.rule.VoidMethodsMustNotBeReturnValueConstrained;
import org.hibernate.validator.internal.util.CollectionHelper;

public class MethodValidationConfiguration {
    private boolean allowOverridingMethodAlterParameterConstraint = false;
    private boolean allowMultipleCascadedValidationOnReturnValues = false;
    private boolean allowParallelMethodsDefineParameterConstraints = false;

    public MethodValidationConfiguration allowOverridingMethodAlterParameterConstraint(boolean allow) {
        this.allowOverridingMethodAlterParameterConstraint = allow;
        return this;
    }

    public MethodValidationConfiguration allowMultipleCascadedValidationOnReturnValues(boolean allow) {
        this.allowMultipleCascadedValidationOnReturnValues = allow;
        return this;
    }

    public MethodValidationConfiguration allowParallelMethodsDefineParameterConstraints(boolean allow) {
        this.allowParallelMethodsDefineParameterConstraints = allow;
        return this;
    }

    public boolean isAllowOverridingMethodAlterParameterConstraint() {
        return this.allowOverridingMethodAlterParameterConstraint;
    }

    public boolean isAllowMultipleCascadedValidationOnReturnValues() {
        return this.allowMultipleCascadedValidationOnReturnValues;
    }

    public boolean isAllowParallelMethodsDefineParameterConstraints() {
        return this.allowParallelMethodsDefineParameterConstraints;
    }

    public Set<MethodConfigurationRule> getConfiguredRuleSet() {
        HashSet result = CollectionHelper.newHashSet();
        if (!this.isAllowOverridingMethodAlterParameterConstraint()) {
            result.add(new OverridingMethodMustNotAlterParameterConstraints());
        }
        if (!this.isAllowParallelMethodsDefineParameterConstraints()) {
            result.add(new ParallelMethodsMustNotDefineParameterConstraints());
        }
        result.add(new VoidMethodsMustNotBeReturnValueConstrained());
        if (!this.isAllowMultipleCascadedValidationOnReturnValues()) {
            result.add(new ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine());
        }
        result.add(new ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue());
        return Collections.unmodifiableSet(result);
    }
}

