/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.util;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.util.MonitorMode;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.SurfaceSize;

public class ScreenModeUtil {
    public static final int NUM_RESOLUTION_PROPERTIES = 2;
    public static final int NUM_SURFACE_SIZE_PROPERTIES = 1;
    public static final int NUM_MONITOR_MODE_PROPERTIES = 3;
    public static final int NUM_SCREEN_MODE_PROPERTIES = 1;
    public static final int NUM_SCREEN_MODE_PROPERTIES_ALL = 8;

    public static int getIndex(List<ScreenMode> list, ScreenMode screenMode) {
        return list.indexOf(screenMode);
    }

    public static int getIndexByHashCode(List<ScreenMode> list, ScreenMode screenMode) {
        for (int i = 0; null != list && i < list.size(); ++i) {
            if (screenMode.hashCode() != list.get(i).hashCode()) continue;
            return i;
        }
        return -1;
    }

    public static List<ScreenMode> filterByResolution(List<ScreenMode> list, DimensionImmutable dimensionImmutable) {
        int n;
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        int n2 = n = dimensionImmutable.getHeight() * dimensionImmutable.getWidth();
        int n3 = 0;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            DimensionImmutable dimensionImmutable2 = screenMode.getMonitorMode().getSurfaceSize().getResolution();
            int n4 = Math.abs(n - dimensionImmutable2.getHeight() * dimensionImmutable2.getWidth());
            if (n4 < n2) {
                n2 = n4;
                n3 = i;
            }
            if (!((Object)dimensionImmutable2).equals(dimensionImmutable)) continue;
            arrayList.add(screenMode);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        dimensionImmutable = list.get(n3).getMonitorMode().getSurfaceSize().getResolution();
        return ScreenModeUtil.filterByResolution(list, dimensionImmutable);
    }

    public static List<ScreenMode> filterBySurfaceSize(List<ScreenMode> list, SurfaceSize surfaceSize) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            if (!screenMode.getMonitorMode().getSurfaceSize().equals(surfaceSize)) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List<ScreenMode> filterByRotation(List<ScreenMode> list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            if (screenMode.getRotation() != n) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List<ScreenMode> filterByBpp(List<ScreenMode> list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            if (screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel() != n) continue;
            arrayList.add(screenMode);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    public static List<ScreenMode> filterByRate(List<ScreenMode> list, int n) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n2 = n;
        int n3 = -1;
        ArrayList<ScreenMode> arrayList = new ArrayList<ScreenMode>();
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            int n4 = Math.abs(n - screenMode.getMonitorMode().getRefreshRate());
            if (n4 < n2) {
                n2 = n4;
                n3 = i;
            }
            if (0 != n4) continue;
            arrayList.add(screenMode);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        n = list.get(n3).getMonitorMode().getRefreshRate();
        return ScreenModeUtil.filterByRate(list, n);
    }

    public static List<ScreenMode> getHighestAvailableBpp(List<ScreenMode> list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n = -1;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            int n2 = screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel();
            if (n2 <= n) continue;
            n = n2;
        }
        return ScreenModeUtil.filterByBpp(list, n);
    }

    public static List<ScreenMode> getHighestAvailableRate(List<ScreenMode> list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        int n = -1;
        for (int i = 0; null != list && i < list.size(); ++i) {
            ScreenMode screenMode = list.get(i);
            int n2 = screenMode.getMonitorMode().getRefreshRate();
            if (n2 <= n) continue;
            n = n2;
        }
        return ScreenModeUtil.filterByRate(list, n);
    }

    public static DimensionImmutable streamInResolution(int[] nArray, int n) {
        Dimension dimension = new Dimension(nArray[n++], nArray[n++]);
        return dimension;
    }

    public static SurfaceSize streamInSurfaceSize(DimensionImmutable dimensionImmutable, int[] nArray, int n) {
        SurfaceSize surfaceSize = new SurfaceSize(dimensionImmutable, nArray[n++]);
        return surfaceSize;
    }

    public static MonitorMode streamInMonitorMode(SurfaceSize surfaceSize, DimensionImmutable dimensionImmutable, int[] nArray, int n) {
        int n2 = nArray[n++];
        return new MonitorMode(surfaceSize, dimensionImmutable, n2);
    }

    public static ScreenMode streamInScreenMode(MonitorMode monitorMode, int[] nArray, int n) {
        int n2 = nArray[n++];
        return new ScreenMode(monitorMode, n2);
    }

    public static ScreenMode streamIn(int[] nArray, int n) {
        return ScreenModeUtil.streamInImpl(null, null, null, null, null, nArray, n);
    }

    public static int streamIn(ArrayHashSet<DimensionImmutable> arrayHashSet, ArrayHashSet<SurfaceSize> arrayHashSet2, ArrayHashSet<DimensionImmutable> arrayHashSet3, ArrayHashSet<MonitorMode> arrayHashSet4, ArrayHashSet<ScreenMode> arrayHashSet5, int[] nArray, int n) {
        ScreenMode screenMode = ScreenModeUtil.streamInImpl(arrayHashSet, arrayHashSet2, arrayHashSet3, arrayHashSet4, arrayHashSet5, nArray, n);
        return arrayHashSet5.indexOf((Object)screenMode);
    }

    private static ScreenMode streamInImpl(ArrayHashSet<DimensionImmutable> arrayHashSet, ArrayHashSet<SurfaceSize> arrayHashSet2, ArrayHashSet<DimensionImmutable> arrayHashSet3, ArrayHashSet<MonitorMode> arrayHashSet4, ArrayHashSet<ScreenMode> arrayHashSet5, int[] nArray, int n) {
        int n2 = nArray[n];
        if (8 != n2) {
            throw new RuntimeException("NUM_SCREEN_MODE_PROPERTIES should be 8, is " + n2 + ", len " + (nArray.length - n));
        }
        if (8 > nArray.length - n) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + (nArray.length - n));
        }
        DimensionImmutable dimensionImmutable = ScreenModeUtil.streamInResolution(nArray, ++n);
        n += 2;
        if (null != arrayHashSet) {
            dimensionImmutable = (DimensionImmutable)arrayHashSet.getOrAdd((Object)dimensionImmutable);
        }
        SurfaceSize surfaceSize = ScreenModeUtil.streamInSurfaceSize(dimensionImmutable, nArray, n);
        ++n;
        if (null != arrayHashSet2) {
            surfaceSize = (SurfaceSize)arrayHashSet2.getOrAdd((Object)surfaceSize);
        }
        DimensionImmutable dimensionImmutable2 = ScreenModeUtil.streamInResolution(nArray, n);
        n += 2;
        if (null != arrayHashSet3) {
            dimensionImmutable2 = (DimensionImmutable)arrayHashSet3.getOrAdd((Object)dimensionImmutable2);
        }
        MonitorMode monitorMode = ScreenModeUtil.streamInMonitorMode(surfaceSize, dimensionImmutable2, nArray, n);
        ++n;
        if (null != arrayHashSet4) {
            monitorMode = (MonitorMode)arrayHashSet4.getOrAdd((Object)monitorMode);
        }
        ScreenMode screenMode = ScreenModeUtil.streamInScreenMode(monitorMode, nArray, n);
        if (null != arrayHashSet5) {
            screenMode = (ScreenMode)arrayHashSet5.getOrAdd((Object)screenMode);
        }
        return screenMode;
    }

    public static int[] streamOut(ScreenMode screenMode) {
        int[] nArray = new int[8];
        int n = 0;
        nArray[n++] = 8;
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getResolution().getWidth();
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getResolution().getHeight();
        nArray[n++] = screenMode.getMonitorMode().getSurfaceSize().getBitsPerPixel();
        nArray[n++] = screenMode.getMonitorMode().getScreenSizeMM().getWidth();
        nArray[n++] = screenMode.getMonitorMode().getScreenSizeMM().getHeight();
        nArray[n++] = screenMode.getMonitorMode().getRefreshRate();
        nArray[n++] = screenMode.getRotation();
        if (8 != n) {
            throw new InternalError("wrong number of attributes: got " + n + " != should " + 8);
        }
        return nArray;
    }
}

