/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.ArcState;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.DataImporter;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Archive
implements RrdUpdater,
ConsolFuns {
    private RrdDb parentDb;
    private RrdString consolFun;
    private RrdDouble xff;
    private RrdInt steps;
    private RrdInt rows;
    private Robin[] robins;
    private ArcState[] states;

    Archive(RrdDb parentDb, ArcDef arcDef) throws IOException {
        boolean shouldInitialize = arcDef != null;
        this.parentDb = parentDb;
        this.consolFun = new RrdString(this, true);
        this.xff = new RrdDouble(this);
        this.steps = new RrdInt(this, true);
        this.rows = new RrdInt(this, true);
        if (shouldInitialize) {
            this.consolFun.set(arcDef.getConsolFun());
            this.xff.set(arcDef.getXff());
            this.steps.set(arcDef.getSteps());
            this.rows.set(arcDef.getRows());
        }
        int n = parentDb.getHeader().getDsCount();
        this.states = new ArcState[n];
        this.robins = new Robin[n];
        int i = 0;
        while (i < n) {
            this.states[i] = new ArcState(this, shouldInitialize);
            int numRows = this.rows.get();
            this.robins[i] = new Robin(this, numRows, shouldInitialize);
            ++i;
        }
    }

    Archive(RrdDb parentDb, DataImporter reader, int arcIndex) throws IOException, RrdException {
        this(parentDb, new ArcDef(reader.getConsolFun(arcIndex), reader.getXff(arcIndex), reader.getSteps(arcIndex), reader.getRows(arcIndex)));
        int n = parentDb.getHeader().getDsCount();
        int i = 0;
        while (i < n) {
            this.states[i].setAccumValue(reader.getStateAccumValue(arcIndex, i));
            this.states[i].setNanSteps(reader.getStateNanSteps(arcIndex, i));
            double[] values = reader.getValues(arcIndex, i);
            this.robins[i].update(values);
            ++i;
        }
    }

    public long getArcStep() throws IOException {
        long step = this.parentDb.getHeader().getStep();
        return step * (long)this.steps.get();
    }

    String dump() throws IOException {
        StringBuffer buffer = new StringBuffer("== ARCHIVE ==\n");
        buffer.append("RRA:").append(this.consolFun.get()).append(":").append(this.xff.get()).append(":").append(this.steps.get()).append(":").append(this.rows.get()).append("\n");
        buffer.append("interval [").append(this.getStartTime()).append(", ").append(this.getEndTime()).append("]\n");
        int i = 0;
        while (i < this.robins.length) {
            buffer.append(this.states[i].dump());
            buffer.append(this.robins[i].dump());
            ++i;
        }
        return buffer.toString();
    }

    RrdDb getParentDb() {
        return this.parentDb;
    }

    void archive(int dsIndex, double value, long numUpdates) throws IOException {
        Robin robin = this.robins[dsIndex];
        ArcState state = this.states[dsIndex];
        long step = this.parentDb.getHeader().getStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        long updateTime = Util.normalize(lastUpdateTime, step) + step;
        long arcStep = this.getArcStep();
        while (numUpdates > 0L) {
            this.accumulate(state, value);
            --numUpdates;
            if (updateTime % arcStep == 0L) {
                this.finalizeStep(state, robin);
                break;
            }
            updateTime += step;
        }
        int bulkUpdateCount = (int)Math.min(numUpdates / (long)this.steps.get(), (long)this.rows.get());
        robin.bulkStore(value, bulkUpdateCount);
        long remainingUpdates = numUpdates % (long)this.steps.get();
        long i = 0L;
        while (i < remainingUpdates) {
            this.accumulate(state, value);
            ++i;
        }
    }

    private void accumulate(ArcState state, double value) throws IOException {
        if (Double.isNaN(value)) {
            state.setNanSteps(state.getNanSteps() + 1L);
        } else if (this.consolFun.get().equals("MIN")) {
            state.setAccumValue(Util.min(state.getAccumValue(), value));
        } else if (this.consolFun.get().equals("MAX")) {
            state.setAccumValue(Util.max(state.getAccumValue(), value));
        } else if (this.consolFun.get().equals("LAST")) {
            state.setAccumValue(value);
        } else if (this.consolFun.get().equals("AVERAGE")) {
            state.setAccumValue(Util.sum(state.getAccumValue(), value));
        }
    }

    private void finalizeStep(ArcState state, Robin robin) throws IOException {
        long arcSteps = this.steps.get();
        double arcXff = this.xff.get();
        long nanSteps = state.getNanSteps();
        double accumValue = state.getAccumValue();
        if ((double)nanSteps <= arcXff * (double)arcSteps && !Double.isNaN(accumValue)) {
            if (this.consolFun.get().equals("AVERAGE")) {
                accumValue /= (double)(arcSteps - nanSteps);
            }
            robin.store(accumValue);
        } else {
            robin.store(Double.NaN);
        }
        state.setAccumValue(Double.NaN);
        state.setNanSteps(0L);
    }

    public String getConsolFun() throws IOException {
        return this.consolFun.get();
    }

    public double getXff() throws IOException {
        return this.xff.get();
    }

    public int getSteps() throws IOException {
        return this.steps.get();
    }

    public int getRows() throws IOException {
        return this.rows.get();
    }

    public long getStartTime() throws IOException {
        long endTime = this.getEndTime();
        long arcStep = this.getArcStep();
        long numRows = this.rows.get();
        return endTime - (numRows - 1L) * arcStep;
    }

    public long getEndTime() throws IOException {
        long arcStep = this.getArcStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        return Util.normalize(lastUpdateTime, arcStep);
    }

    public ArcState getArcState(int dsIndex) {
        return this.states[dsIndex];
    }

    public Robin getRobin(int dsIndex) {
        return this.robins[dsIndex];
    }

    FetchData fetchData(FetchRequest request) throws IOException, RrdException {
        long arcStep = this.getArcStep();
        long fetchStart = Util.normalize(request.getFetchStart(), arcStep);
        long fetchEnd = Util.normalize(request.getFetchEnd(), arcStep);
        if (fetchEnd < request.getFetchEnd()) {
            fetchEnd += arcStep;
        }
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        String[] dsToFetch = request.getFilter();
        if (dsToFetch == null) {
            dsToFetch = this.parentDb.getDsNames();
        }
        int dsCount = dsToFetch.length;
        int ptsCount = (int)((fetchEnd - fetchStart) / arcStep + 1L);
        long[] timestamps = new long[ptsCount];
        double[][] values = new double[dsCount][ptsCount];
        long matchStartTime = Math.max(fetchStart, startTime);
        long matchEndTime = Math.min(fetchEnd, endTime);
        Object robinValues = null;
        if (matchStartTime <= matchEndTime) {
            int matchCount = (int)((matchEndTime - matchStartTime) / arcStep + 1L);
            int matchStartIndex = (int)((matchStartTime - startTime) / arcStep);
            robinValues = new double[dsCount][];
            int i = 0;
            while (i < dsCount) {
                int dsIndex = this.parentDb.getDsIndex(dsToFetch[i]);
                robinValues[i] = this.robins[dsIndex].getValues(matchStartIndex, matchCount);
                ++i;
            }
        }
        int ptIndex = 0;
        while (ptIndex < ptsCount) {
            long time;
            timestamps[ptIndex] = time = fetchStart + (long)ptIndex * arcStep;
            int i = 0;
            while (i < dsCount) {
                double value = Double.NaN;
                if (time >= matchStartTime && time <= matchEndTime) {
                    int robinValueIndex = (int)((time - matchStartTime) / arcStep);
                    assert (robinValues != null);
                    value = robinValues[i][robinValueIndex];
                }
                values[i][ptIndex] = value;
                ++i;
            }
            ++ptIndex;
        }
        FetchData fetchData = new FetchData(this, request);
        fetchData.setTimestamps(timestamps);
        fetchData.setValues(values);
        return fetchData;
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.startTag("rra");
        writer.writeTag("cf", this.consolFun.get());
        writer.writeComment(String.valueOf(this.getArcStep()) + " seconds");
        writer.writeTag("pdp_per_row", this.steps.get());
        writer.writeTag("xff", this.xff.get());
        writer.startTag("cdp_prep");
        ArcState[] arcStateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            ArcState state = arcStateArray[n2];
            state.appendXml(writer);
            ++n2;
        }
        writer.closeTag();
        writer.startTag("database");
        long startTime = this.getStartTime();
        int i = 0;
        while (i < this.rows.get()) {
            long time = startTime + (long)i * this.getArcStep();
            writer.writeComment(Util.getDate(time) + " / " + time);
            writer.startTag("row");
            Robin[] robinArray = this.robins;
            int n3 = this.robins.length;
            int n4 = 0;
            while (n4 < n3) {
                Robin robin = robinArray[n4];
                writer.writeTag("v", robin.getValue(i));
                ++n4;
            }
            writer.closeTag();
            ++i;
        }
        writer.closeTag();
        writer.closeTag();
    }

    public void copyStateTo(RrdUpdater other) throws IOException, RrdException {
        if (!(other instanceof Archive)) {
            throw new RrdException("Cannot copy Archive object to " + other.getClass().getName());
        }
        Archive arc = (Archive)other;
        if (!arc.consolFun.get().equals(this.consolFun.get())) {
            throw new RrdException("Incompatible consolidation functions");
        }
        if (arc.steps.get() != this.steps.get()) {
            throw new RrdException("Incompatible number of steps");
        }
        int count = this.parentDb.getHeader().getDsCount();
        int i = 0;
        while (i < count) {
            int j = Util.getMatchingDatasourceIndex(this.parentDb, i, arc.parentDb);
            if (j >= 0) {
                this.states[i].copyStateTo(arc.states[j]);
                this.robins[i].copyStateTo(arc.robins[j]);
            }
            ++i;
        }
    }

    public void setXff(double xff) throws RrdException, IOException {
        if (xff < 0.0 || xff >= 1.0) {
            throw new RrdException("Invalid xff supplied (" + xff + "), must be >= 0 and < 1");
        }
        this.xff.set(xff);
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

