/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public abstract class AbstractExecutor
implements Executor {
    protected Database database;

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    protected String[] applyVisitors(SqlStatement statement, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Sql[] sql = SqlGeneratorFactory.getInstance().generateSql(statement, this.database);
        if (sql == null) {
            return new String[0];
        }
        String[] returnSql = new String[sql.length];
        for (int i = 0; i < sql.length; ++i) {
            if (sql[i] == null) continue;
            returnSql[i] = sql[i].toSql();
            if (sqlVisitors == null) continue;
            for (SqlVisitor visitor : sqlVisitors) {
                returnSql[i] = visitor.modifySql(returnSql[i], this.database);
            }
        }
        return returnSql;
    }

    @Override
    public void execute(Change change) throws DatabaseException {
        this.execute(change, new ArrayList<SqlVisitor>());
    }

    @Override
    public void execute(Change change, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        SqlStatement[] sqlStatements = change.generateStatements(this.database);
        if (sqlStatements != null) {
            for (SqlStatement statement : sqlStatements) {
                this.execute(statement, sqlVisitors);
            }
        }
    }
}

