/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.supplier.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.sdk.supplier.database.ConnectionConfigurationFactory;
import liquibase.sdk.supplier.database.ConnectionSupplier;
import liquibase.sdk.supplier.database.JDBCDriverClassLoader;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.PotentialAssignment;

public class AllDatabases
extends ParameterSupplier {
    private Map<String, Boolean> connectionsAttempted = new HashMap<String, Boolean>();
    private Map<String, DatabaseConnection> connectionsByUrl = new HashMap<String, DatabaseConnection>();

    public List<PotentialAssignment> getValueSources(ParameterSignature sig) {
        ArrayList<PotentialAssignment> returnList = new ArrayList<PotentialAssignment>();
        for (Database database : DatabaseFactory.getInstance().getImplementedDatabases()) {
            for (ConnectionSupplier config : ConnectionConfigurationFactory.getInstance().getConfigurations(database)) {
                database.setConnection(this.openConnection(config));
                returnList.add(PotentialAssignment.forValue((String)(database.getShortName() + " - " + config.getConfigurationName()), (Object)database));
            }
        }
        return returnList;
    }

    protected DatabaseConnection openConnection(ConnectionSupplier connectionConfig) {
        try {
            final String url = connectionConfig.getJdbcUrl();
            if (this.connectionsAttempted.containsKey(url)) {
                JdbcConnection connection = (JdbcConnection)this.connectionsByUrl.get(url);
                if (connection == null) {
                    return null;
                }
                if (connection.getUnderlyingConnection().isClosed()) {
                    this.connectionsByUrl.put(url, this.openDatabaseConnection(connectionConfig));
                }
                return this.connectionsByUrl.get(url);
            }
            this.connectionsAttempted.put(url, Boolean.TRUE);
            final DatabaseConnection connection = this.openDatabaseConnection(connectionConfig);
            if (connection == null) {
                return null;
            }
            this.connectionsByUrl.put(url, connection);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            if (!((JdbcConnection)connection).getUnderlyingConnection().getAutoCommit()) {
                                ((JdbcConnection)connection).getUnderlyingConnection().rollback();
                            }
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        ((JdbcConnection)connection).getUnderlyingConnection().close();
                    }
                    catch (SQLException e) {
                        System.out.println("Could not close " + url);
                        e.printStackTrace();
                    }
                }
            }));
            return this.connectionsByUrl.get(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DatabaseConnection openDatabaseConnection(ConnectionSupplier connectionSupplier) throws Exception {
        Connection connection;
        Driver driver;
        String url = connectionSupplier.getJdbcUrl();
        Assert.assertNotNull((String)"Null jdbc url", (Object)url);
        String username = connectionSupplier.getDatabaseUsername();
        String password = connectionSupplier.getDatabasePassword();
        JDBCDriverClassLoader jdbcDriverLoader = new JDBCDriverClassLoader();
        try {
            String defaultDriver = DatabaseFactory.getInstance().findDefaultDriver(url);
            driver = (Driver)Class.forName(defaultDriver, true, jdbcDriverLoader).newInstance();
        }
        catch (Exception e) {
            System.out.println("Error finding default driver for " + url + ": Will not test against.  " + e.getMessage());
            return null;
        }
        Properties info = new Properties();
        info.put("user", username);
        if (password != null) {
            info.put("password", password);
        }
        info.put("retrieveMessagesFromServerOnGetMessage", "true");
        try {
            connection = driver.connect(url, info);
        }
        catch (SQLException e) {
            System.out.println("Could not connect to " + url + ": Will not test against.  " + e.getMessage());
            return null;
        }
        if (connection == null) {
            throw new DatabaseException("Connection could not be created to " + url + " with driver " + driver.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
        }
        return new JdbcConnection(connection);
    }
}

