/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.verifytest;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import liquibase.sdk.verifytest.TestPermutation;
import liquibase.sdk.verifytest.VerifiedTest;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;

public class VerifiedTestWriter {
    public void write(VerifiedTest test, Writer out, String group) throws IOException {
        out.append("# Test: ").append(test.getTestClass()).append(" \"").append(test.getTestName()).append("\"");
        if (group != null) {
            out.append(" Group \"").append(group).append("\"");
        }
        out.append(" #\n\n");
        out.append("NOTE: This output is generated when the test is ran. DO NOT EDIT MANUALLY\n\n");
        this.printNonTablePermutations(test, out, group);
        this.printTablePermutations(test, out, group);
        out.flush();
    }

    protected void printNonTablePermutations(VerifiedTest test, Writer out, String group) throws IOException {
        ArrayList<TestPermutation> permutations = new ArrayList<TestPermutation>(test.getPermutations());
        Collections.sort(permutations, new Comparator<TestPermutation>(){

            @Override
            public int compare(TestPermutation o1, TestPermutation o2) {
                return o1.getFullKey().compareTo(o2.getFullKey());
            }
        });
        for (TestPermutation permutation : permutations) {
            if (permutation.getRowDescriptionParameter() != null || !permutation.isValid() || group != null && !group.equals(permutation.getGroup())) continue;
            out.append("## Permutation: ").append(permutation.getKey()).append(" ##\n\n");
            out.append("- _VERIFIED:_ ").append(this.getVerifiedMessage(permutation));
            out.append("\n");
            for (Map.Entry<String, TestPermutation.Value> entry : permutation.getDescription().entrySet()) {
                this.appendMapEntry(entry, out);
            }
            if (permutation.getNotes().size() > 0) {
                out.append("\n");
                out.append("#### Notes ####\n");
                out.append("\n");
                for (Map.Entry<String, TestPermutation.Value> entry : permutation.getNotes().entrySet()) {
                    this.appendMapEntry(entry, out);
                }
            }
            if (permutation.getData().entrySet().size() > 0) {
                out.append("\n");
                out.append("#### Data ####\n");
                out.append("\n");
                for (Map.Entry<String, TestPermutation.Value> entry : permutation.getData().entrySet()) {
                    this.appendMapEntry(entry, out);
                }
            }
            out.append("\n\n");
        }
    }

    private String getVerifiedMessage(TestPermutation permutation) {
        String message = String.valueOf(permutation.getVerified());
        if (!permutation.getVerified() && StringUtils.trimToNull(permutation.getNotRanMessage()) != null) {
            message = message + " " + StringUtils.trimToEmpty(permutation.getNotRanMessage());
        }
        return message;
    }

    /*
     * Could not resolve type clashes
     */
    protected void printTablePermutations(VerifiedTest test, Writer out, String group) throws IOException {
        String tableKey;
        TreeMap permutationsByTable = new TreeMap();
        for (TestPermutation permutation : test.getPermutations()) {
            if (permutation.getRowDescriptionParameter() == null || group != null && !group.equals(permutation.getGroup())) continue;
            tableKey = permutation.getTableKey();
            if (!permutationsByTable.containsKey(tableKey)) {
                permutationsByTable.put(tableKey, new ArrayList());
            }
            ((List)permutationsByTable.get(tableKey)).add(permutation);
        }
        if (permutationsByTable.isEmpty()) {
            return;
        }
        for (Map.Entry entry : permutationsByTable.entrySet()) {
            tableKey = (String)entry.getKey();
            ArrayList<TestPermutation> permutations = new ArrayList<TestPermutation>();
            for (TestPermutation permutation : (List)entry.getValue()) {
                if (!permutation.isValid()) continue;
                permutations.add(permutation);
            }
            if (permutations.size() == 0) continue;
            out.append("## Permutation Group for ").append(((TestPermutation)permutations.get(0)).getRowDescriptionParameter()).append(": ").append(MD5Util.computeMD5(tableKey).substring(0, 16)).append(" ##\n\n");
            for (Map.Entry descriptionEntry : ((TestPermutation)permutations.get(0)).getDescription().entrySet()) {
                this.appendMapEntry(descriptionEntry, out);
            }
            TreeMap<String, Integer> maxColumnLengths = new TreeMap<String, Integer>();
            int permutationNameColLength = "Permutation".length();
            int verifiedColLength = "Verified".length();
            for (TestPermutation permutation : permutations) {
                String verifiedMessage;
                if (permutation.getKey().length() > permutationNameColLength) {
                    permutationNameColLength = permutation.getKey().length();
                }
                if ((verifiedMessage = this.getVerifiedMessage(permutation)).length() > verifiedColLength) {
                    verifiedColLength = verifiedMessage.length();
                }
                Map<String, TestPermutation.Value> columnMap = permutation.getRowDescription();
                for (Map.Entry<String, TestPermutation.Value> columnEntry : columnMap.entrySet()) {
                    String value;
                    Integer oldMax = (Integer)maxColumnLengths.get(columnEntry.getKey());
                    if (oldMax == null) {
                        oldMax = columnEntry.getKey().length();
                        maxColumnLengths.put(columnEntry.getKey(), oldMax);
                    }
                    if ((value = columnEntry.getValue().serialize()) == null || oldMax >= value.length()) continue;
                    maxColumnLengths.put(columnEntry.getKey(), value.length());
                }
            }
            out.append("\n");
            out.append("| ").append(StringUtils.pad("Permutation", permutationNameColLength)).append(" | ").append(StringUtils.pad("Verified", verifiedColLength)).append(" |");
            for (Map.Entry columnEntry : maxColumnLengths.entrySet()) {
                out.append(" ").append(StringUtils.pad((String)columnEntry.getKey(), (Integer)columnEntry.getValue())).append(" |");
            }
            out.append(" DETAILS\n");
            TreeMap<String, String> permutationRows = new TreeMap<String, String>();
            for (TestPermutation permutation : permutations) {
                StringBuilder row = new StringBuilder();
                row.append("| ").append(StringUtils.pad(permutation.getKey(), permutationNameColLength)).append(" | ").append(StringUtils.pad(this.getVerifiedMessage(permutation), verifiedColLength)).append(" |");
                String rowKey = "";
                for (Map.Entry columnAndLength : maxColumnLengths.entrySet()) {
                    TestPermutation.Value cellValue = permutation.getRowDescription().get(columnAndLength.getKey());
                    String cellString = cellValue == null ? "" : this.clean(cellValue.serialize());
                    rowKey = rowKey + " " + StringUtils.pad(cellString, (Integer)columnAndLength.getValue()) + " |";
                }
                row.append(rowKey);
                ArrayList<String> details = new ArrayList<String>();
                for (Map.Entry<String, TestPermutation.Value> notesEntry : permutation.getNotes().entrySet()) {
                    details.add(" __" + notesEntry.getKey() + "__: " + this.clean(notesEntry.getValue().serialize()));
                }
                for (Map.Entry<String, TestPermutation.Value> dataEntry : permutation.getData().entrySet()) {
                    details.add(" **" + dataEntry.getKey() + "**: " + this.clean(dataEntry.getValue().serialize()));
                }
                for (int i = 0; i < details.size(); ++i) {
                    if (i > 0) {
                        row.append("| ").append(StringUtils.pad("", permutationNameColLength)).append(" | ").append(StringUtils.pad("", verifiedColLength)).append(" |");
                        for (Map.Entry nameAndLength : maxColumnLengths.entrySet()) {
                            row.append(" ").append(StringUtils.pad("", (Integer)nameAndLength.getValue())).append(" |");
                        }
                    }
                    row.append((String)details.get(i)).append("\n");
                }
                permutationRows.put(rowKey, row.toString());
            }
            out.append(StringUtils.join(permutationRows.values(), ""));
            out.append("\n\n");
        }
    }

    private String clean(String string) {
        return string.replace("\r\n", "\n").replace("\n", "<br>").replace("|", "\\|");
    }

    private void appendMapEntry(Map.Entry<String, TestPermutation.Value> entry, Writer out) throws IOException {
        String value = entry.getValue().serialize();
        value = value.replace("\r\n", "\n");
        boolean multiLine = value.contains("\n");
        out.append("- **").append(entry.getKey());
        if (multiLine) {
            out.append(" =>**\n");
        } else {
            out.append(":** ");
        }
        if (multiLine) {
            out.append(StringUtils.indent(value, 4));
        } else {
            out.append(value);
        }
        out.append("\n");
    }
}

