/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import java.io.IOException;
import java.net.InetAddress;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.core.util.PortParser;
import org.mockftpserver.stub.command.AbstractStubCommandHandler;

public class PasvCommandHandler
extends AbstractStubCommandHandler
implements CommandHandler {
    public PasvCommandHandler() {
        this.setReplyCode(227);
    }

    public void handleCommand(Command command, Session session, InvocationRecord invocationRecord) throws IOException {
        int port = session.switchToPassiveMode();
        InetAddress server = session.getServerHost();
        Assert.isTrue(port > -1, "The server-side port is invalid: " + port);
        this.LOG.debug((Object)("server=" + server + " port=" + port));
        String hostAndPort = "(" + PortParser.convertHostAndPortToCommaDelimitedBytes(server, port) + ")";
        this.sendReply(session, hostAndPort);
    }
}

