/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonConnexionServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPythonConnexionServerCodegen.class);
    public static final String CONTROLLER_PACKAGE = "controllerPackage";
    public static final String DEFAULT_CONTROLLER = "defaultController";
    public static final String SUPPORT_PYTHON2 = "supportPython2";
    public static final String USE_NOSE = "useNose";
    public static final String PYTHON_SRC_ROOT = "pythonSrcRoot";
    static final String MEDIA_TYPE = "mediaType";
    protected int serverPort = 8080;
    protected String packageName;
    protected String packageVersion;
    protected String controllerPackage;
    protected String defaultController;
    protected Map<Character, String> regexModifiers;
    protected boolean fixBodyName;
    protected boolean useNose = Boolean.FALSE;
    protected String pythonSrcRoot;

    public AbstractPythonConnexionServerCodegen(String templateDirectory, boolean fixBodyNameValue) {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.fixBodyName = fixBodyNameValue;
        this.modelPackage = "models";
        this.testPackage = "test";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.languageSpecificPrimitives.add("date");
        this.languageSpecificPrimitives.add("file");
        this.languageSpecificPrimitives.add("object");
        this.languageSpecificPrimitives.add("byte");
        this.languageSpecificPrimitives.add("bytearray");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "date");
        this.typeMapping.put("DateTime", "datetime");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("file", "file");
        this.typeMapping.put("UUID", "str");
        this.typeMapping.put("URI", "str");
        this.typeMapping.put("byte", "bytearray");
        this.typeMapping.put("ByteArray", "bytearray");
        this.setReservedWordsLowerCase(Arrays.asList("property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "None", "True", "False", "nonlocal"));
        this.outputFolder = "generated-code/connexion";
        this.apiTemplateFiles.put("controller.mustache", ".py");
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTestTemplateFiles().put("controller_test.mustache", ".py");
        this.embeddedTemplateDir = this.templateDir = templateDirectory;
        this.additionalProperties.put("serverPort", this.serverPort);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_server"));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(CONTROLLER_PACKAGE, "controller package").defaultValue("controllers"));
        this.cliOptions.add(new CliOption(DEFAULT_CONTROLLER, "default controller").defaultValue("default_controller"));
        this.cliOptions.add(new CliOption(SUPPORT_PYTHON2, "support python2. This option has been deprecated and will be removed in the 5.x release.").defaultValue("false"));
        this.cliOptions.add(new CliOption("serverPort", "TCP port to listen to in app.run").defaultValue("8080"));
        this.cliOptions.add(CliOption.newBoolean(USE_NOSE, "use the nose test framework").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(PYTHON_SRC_ROOT, "put python sources in this subdirectory of output folder (defaults to \"\" for). Use this for src/ layout.").defaultValue(""));
    }

    protected void addSupportingFiles() {
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi_server");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey(CONTROLLER_PACKAGE)) {
            this.controllerPackage = this.additionalProperties.get(CONTROLLER_PACKAGE).toString();
        } else {
            this.controllerPackage = "controllers";
            this.additionalProperties.put(CONTROLLER_PACKAGE, this.controllerPackage);
        }
        if (this.additionalProperties.containsKey(DEFAULT_CONTROLLER)) {
            this.defaultController = this.additionalProperties.get(DEFAULT_CONTROLLER).toString();
        } else {
            this.defaultController = "default_controller";
            this.additionalProperties.put(DEFAULT_CONTROLLER, this.defaultController);
        }
        if (Boolean.TRUE.equals(this.additionalProperties.get(SUPPORT_PYTHON2))) {
            this.additionalProperties.put(SUPPORT_PYTHON2, Boolean.TRUE);
            this.typeMapping.put("long", "long");
        }
        if (this.additionalProperties.containsKey(USE_NOSE)) {
            this.setUseNose((String)this.additionalProperties.get(USE_NOSE));
        }
        if (this.additionalProperties.containsKey(PYTHON_SRC_ROOT)) {
            this.setPythonSrcRoot((String)this.additionalProperties.get(PYTHON_SRC_ROOT));
            this.additionalProperties.put(PYTHON_SRC_ROOT, this.pythonSrcRoot);
        } else {
            this.setPythonSrcRoot("");
        }
        this.supportingFiles.add(new SupportingFile("__main__.mustache", this.packagePath(), "__main__.py"));
        this.supportingFiles.add(new SupportingFile("util.mustache", this.packagePath(), "util.py"));
        this.supportingFiles.add(new SupportingFile("typing_utils.mustache", this.packagePath(), "typing_utils.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.controllerPackage), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("security_controller_.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.controllerPackage), "security_controller_.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.modelPackage), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("base_model_.mustache", this.packagePath() + File.separatorChar + AbstractPythonConnexionServerCodegen.packageToPath(this.modelPackage), "base_model_.py"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", this.packagePath() + File.separatorChar + "openapi", "openapi.yaml"));
        this.addSupportingFiles();
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.controllerPackage = this.packageName + "." + this.controllerPackage;
    }

    public void setUseNose(String val) {
        this.useNose = Boolean.valueOf(val);
    }

    public void setPythonSrcRoot(String val) {
        String pySrcRoot = val == null ? "" : val.replaceAll("[/\\\\]+$", "");
        this.pythonSrcRoot = pySrcRoot.isEmpty() || ".".equals(pySrcRoot) ? "" : pySrcRoot + File.separator;
    }

    public String pythonSrcOutputFolder() {
        return this.outputFolder + File.separator + this.pythonSrcRoot;
    }

    private static String packageToPath(String pkg) {
        return pkg.replace(".", File.separator);
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public String apiPackage() {
        return this.controllerPackage;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getHelp() {
        return "Generates a Python server library using the Connexion project. By default, it will also generate service classes -- which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name == null || name.length() == 0) {
            return "DefaultController";
        }
        return StringUtils.camelize(name, false) + "Controller";
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        String pkgPath = this.apiPackage().replace('.', File.separatorChar);
        return this.pythonSrcOutputFolder() + pkgPath;
    }

    @Override
    public String modelFileFolder() {
        String pkgPath = this.modelPackage().replace('.', File.separatorChar);
        return this.pythonSrcOutputFolder() + pkgPath;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(schemaType);
        }
        return type;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            ArrayList pathnames = new ArrayList(paths.keySet());
            for (String pathname : pathnames) {
                Map operationMap;
                PathItem path = (PathItem)paths.get(pathname);
                if (pathname.contains("{")) {
                    String fixedPath = new String();
                    for (String token : pathname.substring(1).split("/")) {
                        String snake_case_token;
                        if (token.startsWith("{") && !token.equals(snake_case_token = "{" + this.toParamName(token.substring(1, token.length() - 1)) + "}")) {
                            token = snake_case_token;
                        }
                        fixedPath = fixedPath + "/" + token;
                    }
                    if (!fixedPath.equals(pathname)) {
                        LOGGER.warn("Path '" + pathname + "' is not consistant with Python variable names. It will be replaced by '" + fixedPath + "'");
                        paths.remove(pathname);
                        path.addExtension("x-python-connexion-openapi-name", (Object)pathname);
                        paths.put(fixedPath, path);
                    }
                }
                if ((operationMap = path.readOperationsMap()) == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    String operationId;
                    Operation operation = (Operation)operationMap.get(method);
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = (String)operation.getTags().get(0);
                    }
                    if ((operationId = operation.getOperationId()) == null) {
                        operationId = this.getOrGenerateOperationId(operation, pathname, method.toString());
                    }
                    operation.setOperationId(this.toOperationId(operationId));
                    if (operation.getExtensions() == null || operation.getExtensions().get("x-openapi-router-controller") == null) {
                        operation.addExtension("x-openapi-router-controller", (Object)(this.controllerPackage + "." + this.toApiFilename(tag)));
                    }
                    if (operation.getParameters() != null) {
                        for (Parameter parameter : operation.getParameters()) {
                            String pythonParameterName;
                            String swaggerParameterName = parameter.getName();
                            if (!swaggerParameterName.equals(pythonParameterName = this.toParamName(swaggerParameterName))) {
                                LOGGER.warn("Parameter name '" + swaggerParameterName + "' is not consistant with Python variable names. It will be replaced by '" + pythonParameterName + "'");
                                parameter.addExtension("x-python-connexion-openapi-name", (Object)swaggerParameterName);
                                parameter.setName(pythonParameterName);
                            }
                            if (!swaggerParameterName.isEmpty()) continue;
                            LOGGER.error("Missing parameter name in " + pathname + "." + parameter.getIn());
                        }
                    }
                    RequestBody body = operation.getRequestBody();
                    if (!this.fixBodyName || body == null || body.getExtensions() != null && body.getExtensions().containsKey("x-body-name")) continue;
                    String bodyParameterName = "body";
                    if (operation.getExtensions() != null && operation.getExtensions().containsKey("x-codegen-request-body-name")) {
                        bodyParameterName = (String)operation.getExtensions().get("x-codegen-request-body-name");
                    } else {
                        operation.addExtension("x-codegen-request-body-name", (Object)bodyParameterName);
                    }
                    body.addExtension("x-body-name", (Object)bodyParameterName);
                }
            }
            ArrayList fixedPathnames = new ArrayList(paths.keySet());
            Collections.sort(fixedPathnames);
            for (String pathname : fixedPathnames) {
                PathItem pathItem = (PathItem)paths.remove(pathname);
                paths.put(pathname, pathItem);
            }
        }
        this.addSecurityExtensions(openAPI);
    }

    private void addSecurityExtension(SecurityScheme securityScheme, String extensionName, String functionName) {
        if (securityScheme.getExtensions() == null || !securityScheme.getExtensions().containsKey(extensionName)) {
            securityScheme.addExtension(extensionName, (Object)functionName);
        }
    }

    private void addSecurityExtensions(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components != null && components.getSecuritySchemes() != null) {
            Map securitySchemes = components.getSecuritySchemes();
            block6: for (String securityName : securitySchemes.keySet()) {
                SecurityScheme securityScheme = (SecurityScheme)securitySchemes.get(securityName);
                String baseFunctionName = this.controllerPackage + ".security_controller_.";
                switch (securityScheme.getType()) {
                    case APIKEY: {
                        this.addSecurityExtension(securityScheme, "x-apikeyInfoFunc", baseFunctionName + "info_from_" + securityName);
                        continue block6;
                    }
                    case HTTP: {
                        if ("basic".equals(securityScheme.getScheme())) {
                            this.addSecurityExtension(securityScheme, "x-basicInfoFunc", baseFunctionName + "info_from_" + securityName);
                            continue block6;
                        }
                        if (!"bearer".equals(securityScheme.getScheme())) continue block6;
                        this.addSecurityExtension(securityScheme, "x-bearerInfoFunc", baseFunctionName + "info_from_" + securityName);
                        continue block6;
                    }
                    case OPENIDCONNECT: {
                        LOGGER.warn("Security type " + securityScheme.getType().toString() + " is not supported by connextion yet");
                    }
                    case OAUTH2: {
                        this.addSecurityExtension(securityScheme, "x-tokenInfoFunc", baseFunctionName + "info_from_" + securityName);
                        this.addSecurityExtension(securityScheme, "x-scopeValidateFunc", baseFunctionName + "validate_scope_" + securityName);
                        continue block6;
                    }
                }
                LOGGER.warn("Unknown security type " + securityScheme.getType().toString());
            }
        }
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = false;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            ArrayList pathnames = new ArrayList(paths.keySet());
            for (Object pythonPathname : pathnames) {
                Map operationMap;
                String openapiPathname;
                PathItem path = (PathItem)paths.get(pythonPathname);
                Map pathExtensions = path.getExtensions();
                if (pathExtensions != null && (openapiPathname = (String)pathExtensions.remove("x-python-connexion-openapi-name")) != null && !openapiPathname.equals(pythonPathname)) {
                    LOGGER.info("Path '" + (String)pythonPathname + "' is not consistant with the original OpenAPI definition. It will be replaced back by '" + openapiPathname + "'");
                    paths.remove(pythonPathname);
                    paths.put(openapiPathname, path);
                }
                if ((operationMap = path.readOperationsMap()) == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    Operation operation = (Operation)operationMap.get(method);
                    if (operation.getParameters() == null) continue;
                    for (Parameter parameter : operation.getParameters()) {
                        Map parameterExtensions = parameter.getExtensions();
                        if (parameterExtensions == null) continue;
                        String swaggerParameterName = (String)parameterExtensions.remove("x-python-connexion-openapi-name");
                        if (swaggerParameterName != null) {
                            String pythonParameterName = parameter.getName();
                            if (!swaggerParameterName.equals(pythonParameterName)) {
                                LOGGER.info("Reverting name of parameter '" + pythonParameterName + "' of operation '" + operation.getOperationId() + "' back to '" + swaggerParameterName + "'");
                                parameter.setName(swaggerParameterName);
                                continue;
                            }
                            LOGGER.debug("Name of parameter '" + pythonParameterName + "' of operation '" + operation.getOperationId() + "' was unchanged.");
                            continue;
                        }
                        LOGGER.debug("x-python-connexion-openapi-name was not set on parameter '" + parameter.getName() + "' of operation '" + operation.getOperationId() + "'");
                    }
                }
            }
            ArrayList recoveredPathnames = new ArrayList(paths.keySet());
            Collections.sort(recoveredPathnames);
            for (String pathname : recoveredPathnames) {
                PathItem pathItem = (PathItem)paths.remove(pathname);
                paths.put(pathname, pathItem);
            }
        }
        this.generateJSONSpecFile(objs);
        this.generateYAMLSpecFile(objs);
        for (Map<String, Object> operations : AbstractPythonConnexionServerCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = AbstractPythonConnexionServerCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("$", "")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        name = StringUtils.underscore(name);
        if (this.isReservedWord(name = name.replaceAll("^_*", "")) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "param_callback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(AbstractPythonConnexionServerCodegen.dropDots(this.toModelName(name)));
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (p.getDefault().toString().equalsIgnoreCase("false")) {
                    return "False";
                }
                return "True";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
                return "'" + (String)p.getDefault() + "'";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (p.minimum != null) {
                example = "" + (Integer.valueOf(p.minimum) + 1);
            }
            if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "56";
            }
        } else if ("Long".equalsIgnoreCase(type)) {
            if (p.minimum != null) {
                example = "" + (Long.valueOf(p.minimum) + 1L);
            }
            if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "789";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (p.minimum != null) {
                example = "" + p.minimum;
            } else if (p.maximum != null) {
                example = "" + p.maximum;
            } else if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            example = "(BytesIO(b'some file data'), 'file.txt')";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "{}";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (p.items != null && p.items.defaultValue != null) {
            example = p.items.defaultValue;
        }
        if (example == null) {
            example = Boolean.TRUE.equals(p.isListContainer) ? "[]" : "None";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            if (Boolean.TRUE.equals(p.isBodyParam)) {
                example = "[" + example + "]";
            }
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key': " + example + "}";
        }
        p.example = example;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String packagePath() {
        String pkgPath = this.packageName.replace('.', File.separatorChar);
        return this.pythonSrcRoot + pkgPath;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("'''", "'_'_'");
    }

    @Override
    public String toModelImport(String name) {
        String modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = modelImport + this.modelPackage() + ".";
            }
            modelImport = modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)property.pattern)) {
            this.addImport(model, "import re");
        }
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                mo.put("pyImports", this.toPyImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toPyImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> pyImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> pyImport = new HashMap<String, String>();
            pyImport.put("import", this.toModelImport(im));
            pyImports.add(pyImport);
        }
        return pyImports;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation operation : operationList) {
            Map<Object, Object> consume;
            HashMap<String, String> skipTests = new HashMap<String, String>();
            if (operation.consumes != null) {
                if (operation.consumes.size() == 1) {
                    consume = operation.consumes.get(0);
                    if (!"application/json".equals(consume.get(MEDIA_TYPE)) && !((String)consume.get(MEDIA_TYPE)).endsWith("+json")) {
                        skipTests.put("reason", (String)consume.get(MEDIA_TYPE) + " not supported by Connexion");
                        if ("multipart/form-data".equals(consume.get(MEDIA_TYPE))) {
                            operation.isMultipart = Boolean.TRUE;
                        }
                    }
                    operation.vendorExtensions.put("x-prefered-consume", consume);
                } else if (operation.consumes.size() > 1) {
                    consume = operation.consumes.get(0);
                    skipTests.put("reason", "Connexion does not support multiple consummes. See https://github.com/zalando/connexion/pull/760");
                    operation.vendorExtensions.put("x-prefered-consume", consume);
                    if ("multipart/form-data".equals(consume.get(MEDIA_TYPE))) {
                        operation.isMultipart = Boolean.TRUE;
                    }
                }
            } else if (operation.bodyParam != null) {
                consume = new HashMap<String, String>();
                consume.put(MEDIA_TYPE, "application/json");
                operation.vendorExtensions.put("x-prefered-consume", consume);
                skipTests.put("reason", "*/* not supported by Connexion. Use application/json instead. See https://github.com/zalando/connexion/pull/760");
            }
            if (operation.produces != null) {
                for (Map<String, String> produce : operation.produces) {
                    operation.vendorExtensions.put("x-prefered-produce", produce);
                    if (!produce.get(MEDIA_TYPE).equals("application/json")) continue;
                    break;
                }
            }
            if (!skipTests.isEmpty()) {
                operation.vendorExtensions.put("x-skip-test", skipTests);
            }
            if (operation.requestBodyExamples == null) continue;
            for (Map<String, String> example : operation.requestBodyExamples) {
                if (example.get("contentType") == null || !example.get("contentType").equals("application/json")) continue;
                operation.bodyParam.example = example.get("example");
            }
        }
        return objs;
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String pythonPostProcessFile = System.getenv("PYTHON_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pythonPostProcessFile)) {
            return;
        }
        if ("py".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = pythonPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }
}

