/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.api;

import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.codegen.api.TemplateFileType;

public class TemplateDefinition {
    private final String templateFile;
    private final String folder;
    private final String destinationFilename;
    protected TemplateFileType templateType;

    public TemplateDefinition(String templateFile, String destinationFilename) {
        this(templateFile, "", destinationFilename);
    }

    public TemplateDefinition() {
        this("", "", "");
    }

    public TemplateDefinition(String templateFile, String folder, String destinationFilename) {
        if (templateFile == null) {
            throw new IllegalArgumentException("templateFile may not be null.");
        }
        if (folder == null) {
            throw new IllegalArgumentException("folder may not be null.");
        }
        if (destinationFilename == null) {
            throw new IllegalArgumentException("destinationFilename may not be null.");
        }
        this.templateFile = templateFile;
        this.folder = folder;
        this.destinationFilename = destinationFilename;
        this.templateType = TemplateFileType.SupportingFiles;
    }

    public String getDestinationFilename() {
        return this.destinationFilename;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public TemplateFileType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateFileType templateType) {
        this.templateType = templateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateDefinition)) {
            return false;
        }
        TemplateDefinition that = (TemplateDefinition)o;
        return this.getTemplateFile().equals(that.getTemplateFile()) && this.getFolder().equals(that.getFolder()) && this.getDestinationFilename().equals(that.getDestinationFilename()) && this.getTemplateType() == that.getTemplateType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTemplateFile(), this.getFolder(), this.getDestinationFilename(), this.getTemplateType()});
    }

    public String toString() {
        return new StringJoiner(", ", TemplateDefinition.class.getSimpleName() + "[", "]").add("templateFile='" + this.templateFile + "'").add("folder='" + this.folder + "'").add("destinationFilename='" + this.destinationFilename + "'").add("templateType=" + this.templateType).toString();
    }
}

