/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.springframework.hateoas.mvc.ResourceProcessorHandlerMethodReturnValueHandler;
import org.springframework.hateoas.mvc.ResourceProcessorInvoker;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class ResourceProcessorInvokingHandlerAdapter
extends RequestMappingHandlerAdapter {
    private static final Method RETURN_VALUE_HANDLER_METHOD = ReflectionUtils.findMethod(ResourceProcessorInvokingHandlerAdapter.class, (String)"getReturnValueHandlers");
    @NonNull
    private final ResourceProcessorInvoker invoker;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        HandlerMethodReturnValueHandlerComposite oldHandlers = this.getReturnValueHandlersComposite();
        ArrayList<ResourceProcessorHandlerMethodReturnValueHandler> newHandlers = new ArrayList<ResourceProcessorHandlerMethodReturnValueHandler>();
        newHandlers.add(new ResourceProcessorHandlerMethodReturnValueHandler((HandlerMethodReturnValueHandler)oldHandlers, this.invoker));
        this.setReturnValueHandlers(newHandlers);
    }

    private HandlerMethodReturnValueHandlerComposite getReturnValueHandlersComposite() {
        Object handlers = ReflectionUtils.invokeMethod((Method)RETURN_VALUE_HANDLER_METHOD, (Object)((Object)this));
        if (handlers instanceof HandlerMethodReturnValueHandlerComposite) {
            return (HandlerMethodReturnValueHandlerComposite)handlers;
        }
        return new HandlerMethodReturnValueHandlerComposite().addHandlers((List)handlers);
    }

    public ResourceProcessorInvokingHandlerAdapter(@NonNull ResourceProcessorInvoker invoker) {
        if (invoker == null) {
            throw new NullPointerException("invoker is marked @NonNull but is null");
        }
        this.invoker = invoker;
    }
}

