/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.swing;

import colorzoo.swing.AbstractMultiThumbModel;
import colorzoo.swing.MultiThumbModel;
import colorzoo.swing.Thumb;
import colorzoo.swing.ThumbDataEvent;
import colorzoo.swing.ThumbDataListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiThumbModel<E>
extends AbstractMultiThumbModel<E>
implements MultiThumbModel<E> {
    protected List<Thumb<E>> thumbs = new ArrayList<Thumb<E>>();

    public DefaultMultiThumbModel() {
        this.setMinimumValue(0.0f);
        this.setMaximumValue(1.0f);
    }

    @Override
    public void addThumb(float f, E e) {
        Thumb<E> thumb = new Thumb<E>();
        thumb.setPosition(f);
        thumb.setObject(e);
        this.thumbs.add(thumb);
        ThumbDataEvent thumbDataEvent = new ThumbDataEvent(this, -1, this.thumbs.size() - 1, thumb);
        for (ThumbDataListener thumbDataListener : this.thumbDataListeners) {
            thumbDataListener.thumbAdded(thumbDataEvent);
        }
    }

    @Override
    public void insertThumb(float f, E e, int n) {
        Thumb<E> thumb = new Thumb<E>();
        thumb.setPosition(f);
        thumb.setObject(e);
        this.thumbs.add(n, thumb);
        ThumbDataEvent thumbDataEvent = new ThumbDataEvent(this, -1, n, thumb);
        for (ThumbDataListener thumbDataListener : this.thumbDataListeners) {
            thumbDataListener.thumbAdded(thumbDataEvent);
        }
    }

    @Override
    public void removeThumb(int n) {
        Thumb<E> thumb = this.thumbs.remove(n);
        ThumbDataEvent thumbDataEvent = new ThumbDataEvent(this, -1, n, thumb);
        for (ThumbDataListener thumbDataListener : this.thumbDataListeners) {
            thumbDataListener.thumbRemoved(thumbDataEvent);
        }
    }

    @Override
    public int getThumbCount() {
        return this.thumbs.size();
    }

    @Override
    public Thumb getThumbAt(int n) {
        return this.thumbs.get(n);
    }

    @Override
    public List<Thumb<E>> getSortedThumbs() {
        ArrayList<Thumb<Thumb<E>>> arrayList = new ArrayList<Thumb<Thumb<E>>>();
        arrayList.addAll(this.thumbs);
        Collections.sort(arrayList, new Comparator<Thumb<E>>(){

            @Override
            public int compare(Thumb<E> thumb, Thumb<E> thumb2) {
                float f;
                float f2 = thumb.getPosition();
                if (f2 < (f = thumb2.getPosition())) {
                    return -1;
                }
                if (f2 > f) {
                    return 1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    @Override
    public Iterator<Thumb<E>> iterator() {
        return this.thumbs.iterator();
    }
}

