/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.response;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.serialize.JsonUtils;

public class AskResponse
implements PowerSerializable {
    private boolean success;
    private byte[] data;
    private String message;

    public static AskResponse succeed(Object data) {
        AskResponse r = new AskResponse();
        r.success = true;
        if (data != null) {
            r.data = data instanceof String ? ((String)data).getBytes(StandardCharsets.UTF_8) : JsonUtils.toBytes(data);
        }
        return r;
    }

    public static AskResponse failed(String msg) {
        AskResponse r = new AskResponse();
        r.success = false;
        r.message = msg;
        return r;
    }

    public <T> T getData(Class<T> clz) throws Exception {
        return JsonUtils.parseObject(this.data, clz);
    }

    public String parseDataAsString() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AskResponse)) {
            return false;
        }
        AskResponse other = (AskResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AskResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getData());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "AskResponse(success=" + this.isSuccess() + ", data=" + Arrays.toString(this.getData()) + ", message=" + this.getMessage() + ")";
    }

    public AskResponse() {
    }

    public AskResponse(boolean success, byte[] data, String message) {
        this.success = success;
        this.data = data;
        this.message = message;
    }
}

