/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperInfo;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.resources.ResourceManager;

public final class WrapperManager
implements Runnable {
    private static final String WRAPPER_CONNECTION_THREAD_NAME = "Wrapper-Connection";
    private static final int DEFAULT_PORT = 15003;
    private static final int DEFAULT_SO_TIMEOUT = 10000;
    private static final long DEFAULT_CPU_TIMEOUT = 10000L;
    private static final byte WRAPPER_MSG_START = 100;
    private static final byte WRAPPER_MSG_STOP = 101;
    private static final byte WRAPPER_MSG_RESTART = 102;
    private static final byte WRAPPER_MSG_PING = 103;
    private static final byte WRAPPER_MSG_STOP_PENDING = 104;
    private static final byte WRAPPER_MSG_START_PENDING = 105;
    private static final byte WRAPPER_MSG_STARTED = 106;
    private static final byte WRAPPER_MSG_STOPPED = 107;
    private static final byte WRAPPER_MSG_KEY = 110;
    private static final byte WRAPPER_MSG_BADKEY = 111;
    private static final byte WRAPPER_MSG_LOW_LOG_LEVEL = 112;
    private static final byte WRAPPER_MSG_PING_TIMEOUT = 113;
    private static final byte WRAPPER_MSG_LOG = 116;
    public static final int WRAPPER_CTRL_C_EVENT = 200;
    public static final int WRAPPER_CTRL_CLOSE_EVENT = 201;
    public static final int WRAPPER_CTRL_LOGOFF_EVENT = 202;
    public static final int WRAPPER_CTRL_SHUTDOWN_EVENT = 203;
    public static final int WRAPPER_LOG_LEVEL_DEBUG = 1;
    public static final int WRAPPER_LOG_LEVEL_INFO = 2;
    public static final int WRAPPER_LOG_LEVEL_STATUS = 3;
    public static final int WRAPPER_LOG_LEVEL_WARN = 4;
    public static final int WRAPPER_LOG_LEVEL_ERROR = 5;
    public static final int WRAPPER_LOG_LEVEL_FATAL = 6;
    private static boolean m_disposed;
    private static boolean m_started;
    private static WrapperManager m_instance;
    private static Thread m_hook;
    private static boolean m_hookTriggered;
    private static String[] m_args;
    private static int m_port;
    private static String m_key;
    private static int m_soTimeout;
    private static long m_cpuTimeout;
    private static int m_systemThreadCount;
    private static int m_lowLogLevel;
    private static int m_pingTimeout;
    private static Thread m_commRunner;
    private static boolean m_commRunnerStarted;
    private static Thread m_eventRunner;
    private static long m_eventRunnerTime;
    private static WrapperListener m_listener;
    private static long m_lastPing;
    private static ServerSocket m_serverSocket;
    private static Socket m_socket;
    private static boolean m_shuttingDown;
    private static boolean m_appearHung;
    private static Method m_addShutdownHookMethod;
    private static Method m_removeShutdownHookMethod;
    private static boolean m_service;
    private static boolean m_debug;
    private static int m_jvmId;
    private static boolean m_stopping;
    private static Thread m_stoppingThread;
    private static boolean m_libraryOK;
    private static byte[] m_commandBuffer;
    private static ResourceManager m_res;
    private static ResourceManager m_error;
    private static ResourceManager m_warning;
    private static ResourceManager m_info;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    private static native void nativeInit(boolean var0);

    private static native int nativeGetControlEvent();

    private static native void nativeRequestThreadDump();

    private static native void accessViolationInner();

    public static String getVersion() {
        return WrapperInfo.getVersion();
    }

    public static String getBuildTime() {
        return WrapperInfo.getBuildTime();
    }

    public static int getJVMId() {
        return m_jvmId;
    }

    public static void requestThreadDump() {
        System.out.println("Dumping JVM state.");
        if (m_libraryOK) {
            WrapperManager.nativeRequestThreadDump();
        } else {
            System.out.println("  wrapper library not loaded.");
        }
    }

    public static void appearHung() {
        System.out.println("WARNING: Making JVM appear to be hung...");
        m_appearHung = true;
    }

    public static void accessViolation() {
        block3: {
            System.out.println("WARNING: Attempting to cause an access violation...");
            try {
                Class<?> c = Class.forName("java.lang.String");
                Method m = c.getDeclaredMethod(null, null);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                if (ex instanceof NoSuchFieldException) break block3;
                ex.printStackTrace();
            }
        }
        System.out.println("  Attempt to cause access violation failed.  JVM is still alive.");
    }

    public static void accessViolationNative() {
        System.out.println("WARNING: Attempting to cause an access violation...");
        if (m_libraryOK) {
            WrapperManager.accessViolationInner();
            System.out.println("  Attempt to cause access violation failed.  JVM is still alive.");
        } else {
            System.out.println("  wrapper library not loaded.");
        }
    }

    public static boolean isControlledByNativeWrapper() {
        return m_key != null;
    }

    public static boolean isLaunchedAsService() {
        return m_service;
    }

    public static boolean isDebugEnabled() {
        return m_debug;
    }

    public static synchronized void start(WrapperListener listener, String[] args) {
        System.out.println("Wrapper (Version " + WrapperManager.getVersion() + ")");
        System.out.println();
        if (m_disposed) {
            throw new IllegalStateException("WrapperManager has already been disposed.");
        }
        if (m_listener != null) {
            throw new IllegalStateException("WrapperManager has already been started with a WrapperListener.");
        }
        if (listener == null) {
            throw new IllegalStateException("A WrapperListener must be specified.");
        }
        m_listener = listener;
        m_args = args;
        WrapperManager.startRunner();
        if (!WrapperManager.isControlledByNativeWrapper()) {
            WrapperManager.startInner();
        }
    }

    public static void restart() {
        boolean stopping;
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            WrapperManager.sendCommand((byte)102, "restart");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WrapperManager.stopInner(0);
    }

    public static void stop(int exitCode) {
        boolean stopping;
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            WrapperManager.sendCommand((byte)101, Integer.toString(exitCode));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WrapperManager.stopInner(exitCode);
    }

    public static void signalStarting(int waitHint) {
        WrapperManager.sendCommand((byte)105, Integer.toString(waitHint));
    }

    public static void signalStopping(int waitHint) {
        m_stopping = true;
        WrapperManager.sendCommand((byte)104, Integer.toString(waitHint));
    }

    public static void signalStopped(int exitCode) {
        m_stopping = true;
        WrapperManager.sendCommand((byte)107, Integer.toString(exitCode));
    }

    public static boolean hasShutdownHookBeenTriggered() {
        return m_hookTriggered;
    }

    public static void log(int logLevel, String message) {
        if (logLevel < 1 || logLevel > 6) {
            throw new IllegalArgumentException("The specified logLevel is not valid.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The message parameter can not be null.");
        }
        if (m_lowLogLevel <= logLevel) {
            WrapperManager.sendCommand((byte)(116 + logLevel), message);
        }
    }

    private WrapperManager() {
    }

    private static void dispose() {
        Class<?> clazz = m_instance.getClass();
        synchronized (clazz) {
            m_disposed = true;
            WrapperManager.closeSocket();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void startInner() {
        int oldPriority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(5);
        if (m_debug) {
            System.out.println("calling listener.start()");
        }
        if (m_listener != null) {
            try {
                Integer result = m_listener.start(m_args);
                if (result != null) {
                    int exitCode = result;
                    WrapperManager.stop(exitCode);
                    return;
                }
            }
            catch (Throwable t) {
                System.out.println("Error in WrapperListener.start callback.  " + t);
                t.printStackTrace();
                WrapperManager.stopInner(1);
                return;
            }
        }
        if (m_debug) {
            System.out.println("returned from listener.start()");
        }
        Thread.currentThread().setPriority(oldPriority);
        WrapperManager.signalStarted();
    }

    private static void shutdownJVM(int exitCode) {
        if (Thread.currentThread() == m_hook) {
            WrapperManager.signalStopped(0);
            WrapperManager.dispose();
        } else {
            if (m_hook != null) {
                try {
                    m_removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), m_hook);
                }
                catch (IllegalAccessException e) {
                    System.out.println("Wrapper Manager: Unable to unregister shutdown hook: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println("Wrapper Manager: Unable to unregister shutdown hook: " + e.getMessage());
                }
                m_hook = null;
            }
            WrapperManager.signalStopped(0);
            WrapperManager.dispose();
            if (m_debug) {
                System.out.println("calling System.exit(" + exitCode + ")");
            }
            System.exit(exitCode);
        }
    }

    private static void stopInner(int exitCode) {
        boolean block;
        WrapperManager wrapperManager = m_instance;
        synchronized (wrapperManager) {
            m_stopping = true;
            if (m_stoppingThread == null) {
                m_stoppingThread = Thread.currentThread();
                block = false;
            } else {
                if (Thread.currentThread() == m_stoppingThread) {
                    throw new IllegalStateException("WrapperManager.stop() can not be called recursively.");
                }
                if (Thread.currentThread() == m_hook) {
                    return;
                }
                block = true;
            }
        }
        if (block) {
            if (m_debug) {
                System.out.println("Thread, " + Thread.currentThread().getName() + ", waiting for the JVM to exit.");
            }
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
        if (m_debug) {
            System.out.println("Thread, " + Thread.currentThread().getName() + ", handling the shutdown process.");
        }
        int code = exitCode;
        if (m_started) {
            int oldPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(5);
            if (m_debug) {
                System.out.println("calling listener.stop()");
            }
            if (m_listener != null) {
                try {
                    code = m_listener.stop(code);
                }
                catch (Throwable t) {
                    System.out.println("Error in WrapperListener.stop callback.  " + t);
                    t.printStackTrace();
                }
            }
            if (m_debug) {
                System.out.println("returned from listener.stop()");
            }
            Thread.currentThread().setPriority(oldPriority);
        }
        WrapperManager.shutdownJVM(code);
    }

    private static void signalStarted() {
        WrapperManager.sendCommand((byte)106, "");
        m_started = true;
    }

    private static void controlEvent(int event) {
        if (m_debug) {
            String eventName;
            switch (event) {
                case 200: {
                    eventName = "WRAPPER_CTRL_C_EVENT";
                    break;
                }
                case 201: {
                    eventName = "WRAPPER_CTRL_CLOSE_EVENT";
                    break;
                }
                case 202: {
                    eventName = "WRAPPER_CTRL_LOGOFF_EVENT";
                    break;
                }
                case 203: {
                    eventName = "WRAPPER_CTRL_SHUTDOWN_EVENT";
                    break;
                }
                default: {
                    eventName = "Unexpected event: " + event;
                }
            }
            System.out.println("Processing control event(" + eventName + ")");
        }
        if (m_listener != null) {
            try {
                m_listener.controlEvent(event);
            }
            catch (Throwable t) {
                System.out.println("Error in WrapperListener.controlEvent callback.  " + t);
                t.printStackTrace();
            }
        }
    }

    private static synchronized Socket openSocket() {
        InetAddress iNetAddress;
        if (m_debug) {
            System.out.println("Open socket to wrapper...");
        }
        try {
            iNetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            WrapperManager.stop(1);
            return null;
        }
        try {
            m_socket = new Socket(iNetAddress, m_port);
            if (m_debug) {
                System.out.println("Opened Socket");
            }
        }
        catch (BindException e) {
            System.out.println("Failed to bind to the Wrapper port.");
            System.out.println(e);
            System.out.println("Exiting JVM...");
            System.exit(1);
        }
        catch (ConnectException e) {
            System.out.println("Failed to connect to the Wrapper.");
            System.out.println(e);
            System.out.println("Exiting JVM...");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println(e);
            m_socket = null;
            return null;
        }
        try {
            m_socket.setTcpNoDelay(true);
            if (m_soTimeout > 0) {
                m_socket.setSoTimeout(m_soTimeout);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        WrapperManager.sendCommand((byte)110, m_key);
        return m_socket;
    }

    private static synchronized void closeSocket() {
        if (m_socket != null) {
            if (m_debug) {
                System.out.println("Closing socket.");
            }
            try {
                try {
                    m_socket.close();
                }
                catch (IOException e) {
                    Object var2_1 = null;
                    m_socket = null;
                }
                Object var2 = null;
                m_socket = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                m_socket = null;
                throw throwable;
            }
        }
    }

    private static synchronized void sendCommand(byte code, String message) {
        if (m_debug) {
            System.out.println("Send a packet " + code + " : " + message);
        }
        if (!m_appearHung) {
            Socket socket = m_socket;
            if (socket == null && WrapperManager.isControlledByNativeWrapper() && !m_stopping) {
                socket = WrapperManager.openSocket();
            }
            if (code == 105 || code == 106) {
                m_lastPing = System.currentTimeMillis();
            }
            if (socket != null) {
                try {
                    byte[] messageBytes = message.getBytes();
                    if (m_commandBuffer.length < messageBytes.length + 2) {
                        m_commandBuffer = new byte[messageBytes.length + 2];
                    }
                    WrapperManager.m_commandBuffer[0] = code;
                    System.arraycopy(messageBytes, 0, m_commandBuffer, 1, messageBytes.length);
                    int len = messageBytes.length + 2;
                    WrapperManager.m_commandBuffer[len - 1] = 0;
                    OutputStream os = socket.getOutputStream();
                    os.write(m_commandBuffer, 0, len);
                    os.flush();
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                    WrapperManager.closeSocket();
                }
            }
        }
    }

    private static void handleSocket() {
        byte[] buffer = new byte[256];
        try {
            if (m_debug) {
                System.out.println("handleSocket(" + m_socket + ")");
            }
            DataInputStream is = new DataInputStream(m_socket.getInputStream());
            while (!m_disposed) {
                block27: {
                    try {
                        byte b;
                        byte code = is.readByte();
                        int i = 0;
                        do {
                            if ((b = is.readByte()) == 0 || i >= 256) continue;
                            buffer[i] = b;
                            ++i;
                        } while (b != 0);
                        String msg = new String(buffer, 0, i);
                        if (m_appearHung) break block27;
                        if (m_debug) {
                            System.out.println("Received a packet " + code + " : " + msg);
                        }
                        switch (code) {
                            case 100: {
                                WrapperManager.startInner();
                                break;
                            }
                            case 101: {
                                if (!m_stopping) {
                                    WrapperManager.stopInner(0);
                                }
                                break;
                            }
                            case 103: {
                                m_lastPing = System.currentTimeMillis();
                                WrapperManager.sendCommand((byte)103, "ok");
                                break;
                            }
                            case 111: {
                                System.out.println("Authorization key rejected by Wrapper.  Exiting JVM.");
                                WrapperManager.closeSocket();
                                WrapperManager.stopInner(1);
                                break;
                            }
                            case 112: {
                                try {
                                    m_lowLogLevel = Integer.parseInt(msg);
                                    if (m_debug) {
                                        System.out.println("Wrapper Manager: LowLogLevel from Wrapper is " + m_lowLogLevel);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Encountered an Illegal LowLogLevel from the Wrapper: " + msg);
                                }
                                break;
                            }
                            case 113: {
                                try {
                                    m_pingTimeout = Integer.parseInt(msg) * 1000;
                                    if (m_debug) {
                                        System.out.println("Wrapper Manager: PingTimeout from Wrapper is " + m_pingTimeout);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Encountered an Illegal PingTimeout from the Wrapper: " + msg);
                                }
                                break;
                            }
                            default: {
                                System.out.println("Wrapper code received an unknown packet type: " + code);
                            }
                        }
                    }
                    catch (InterruptedIOException e) {
                        long now = System.currentTimeMillis();
                        if (!m_started || m_stopping) break block27;
                        if (m_debug) {
                            System.out.println("Read Timed out. (Last Ping was " + (now - m_lastPing) + " milliseconds ago)");
                        }
                        if (m_appearHung) break block27;
                        long lastPingAge = now - m_lastPing;
                        long eventRunnerAge = now - m_eventRunnerTime;
                        if (eventRunnerAge >= 10000L || m_pingTimeout <= 0) break block27;
                        if (lastPingAge > (long)(m_pingTimeout + 90000)) {
                            System.out.println("Wrapper Manager: JVM did not exit.  Give up.");
                            System.exit(1);
                        }
                        if (lastPingAge <= (long)m_pingTimeout) break block27;
                        System.out.println("Wrapper Manager: The Wrapper code did not ping the JVM for " + lastPingAge / 1000L + " seconds.  " + "Quit and let the Wrapper resynch.");
                        if (m_stopping) break block27;
                        WrapperManager.stopInner(1);
                    }
                }
                if (!m_started) continue;
                WrapperManager.checkThreads();
            }
            return;
        }
        catch (SocketException e) {
            if (m_debug && m_socket != null) {
                System.out.println("Closed socket: " + e);
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    protected static int getNonDaemonThreadCount() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        while (topGroup.getParent() != null) {
            topGroup = topGroup.getParent();
        }
        Thread[] threads = new Thread[topGroup.activeCount() * 2];
        topGroup.enumerate(threads, true);
        int liveCount = 0;
        int i = 0;
        while (i < threads.length) {
            if (threads[i] != null && threads[i].isAlive() && !threads[i].isDaemon() && Thread.currentThread() != threads[i] && threads[i] != m_commRunner) {
                ++liveCount;
            }
            ++i;
        }
        return liveCount;
    }

    private static void checkThreads() {
        int liveCount = WrapperManager.getNonDaemonThreadCount();
        if (liveCount <= m_systemThreadCount) {
            if (m_debug) {
                System.out.println("All non-daemon threads have stopped.  Exiting.");
            }
            WrapperManager.stop(0);
        }
    }

    private static void startRunner() {
        if (WrapperManager.isControlledByNativeWrapper() && m_commRunner == null) {
            m_commRunner = new Thread((Runnable)m_instance, WRAPPER_CONNECTION_THREAD_NAME);
            m_commRunner.start();
        }
    }

    public void run() {
        m_commRunnerStarted = true;
        Thread.currentThread().setPriority(10);
        m_lastPing = System.currentTimeMillis();
        boolean gotPortOnce = false;
        while (!m_disposed) {
            try {
                Object var4_7;
                try {
                    WrapperManager.openSocket();
                    if (m_socket != null) {
                        WrapperManager.handleSocket();
                    } else {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    var4_7 = null;
                }
                catch (Throwable throwable) {
                    var4_7 = null;
                    WrapperManager.closeSocket();
                    throw throwable;
                }
                WrapperManager.closeSocket();
                {
                }
            }
            catch (ThreadDeath td) {
                System.out.println(m_warning.format("SERVER_DAEMON_KILLED"));
            }
            catch (Throwable t) {
                if (m_shuttingDown) continue;
                System.out.println(m_error.format("SERVER_DAEMON_DIED"));
                t.printStackTrace();
            }
        }
        if (m_debug) {
            System.out.println(m_info.format("SERVER_DAEMON_SHUT_DOWN"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block35: {
            block36: {
                WrapperManager.m_disposed = false;
                WrapperManager.m_started = false;
                WrapperManager.m_instance = null;
                WrapperManager.m_hook = null;
                WrapperManager.m_hookTriggered = false;
                WrapperManager.m_port = 15003;
                WrapperManager.m_soTimeout = 10000;
                WrapperManager.m_cpuTimeout = 10000L;
                WrapperManager.m_lowLogLevel = 7;
                WrapperManager.m_pingTimeout = 30000;
                WrapperManager.m_commRunnerStarted = false;
                WrapperManager.m_shuttingDown = false;
                WrapperManager.m_appearHung = false;
                WrapperManager.m_addShutdownHookMethod = null;
                WrapperManager.m_removeShutdownHookMethod = null;
                WrapperManager.m_service = false;
                WrapperManager.m_debug = false;
                WrapperManager.m_jvmId = 0;
                WrapperManager.m_stopping = false;
                WrapperManager.m_libraryOK = false;
                WrapperManager.m_commandBuffer = new byte[512];
                WrapperManager.m_error = WrapperManager.m_res = ResourceManager.getResourceManager();
                WrapperManager.m_warning = WrapperManager.m_res;
                WrapperManager.m_info = WrapperManager.m_res;
                WrapperManager.m_debug = System.getProperty("wrapper.debug") != null;
                jvmId = System.getProperty("wrapper.jvmid");
                if (jvmId != null) {
                    try {
                        WrapperManager.m_jvmId = Integer.parseInt(jvmId);
                    }
                    catch (NumberFormatException e) {
                        WrapperManager.m_jvmId = 1;
                    }
                } else {
                    WrapperManager.m_jvmId = 1;
                }
                if (WrapperManager.m_debug) {
                    System.out.println("Wrapper Manager: JVM #" + WrapperManager.m_jvmId);
                }
                disableShutdownHook = System.getProperty("wrapper.disable_shutdown_hook") != null;
                try {
                    WrapperManager.m_addShutdownHookMethod = (WrapperManager.class$java$lang$Runtime == null ? (WrapperManager.class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : WrapperManager.class$java$lang$Runtime).getMethod("addShutdownHook", new Class[]{WrapperManager.class$java$lang$Thread == null ? (WrapperManager.class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : WrapperManager.class$java$lang$Thread});
                    WrapperManager.m_removeShutdownHookMethod = (WrapperManager.class$java$lang$Runtime == null ? (WrapperManager.class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : WrapperManager.class$java$lang$Runtime).getMethod("removeShutdownHook", new Class[]{WrapperManager.class$java$lang$Thread == null ? (WrapperManager.class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : WrapperManager.class$java$lang$Thread});
                }
                catch (NoSuchMethodException e) {
                    if (WrapperManager.m_debug) {
                        System.out.println("Wrapper Manager: Shutdown hooks not supported by current JVM.");
                    }
                    WrapperManager.m_addShutdownHookMethod = null;
                    WrapperManager.m_removeShutdownHookMethod = null;
                    disableShutdownHook = true;
                }
                if (!disableShutdownHook) {
                    if (WrapperManager.m_debug) {
                        System.out.println("Wrapper Manager: Registering shutdown hook");
                    }
                    WrapperManager.m_hook = new Thread("Wrapper-Shutdown-Hook"){

                        public void run() {
                            if (m_debug) {
                                System.out.println("Wrapper Manager: ShutdownHook started");
                            }
                            m_hookTriggered = true;
                            WrapperManager.stop(0);
                            if (m_debug) {
                                System.out.println("Wrapper Manager: ShutdownHook complete");
                            }
                        }
                    };
                    try {
                        WrapperManager.m_addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), new Object[]{WrapperManager.m_hook});
                    }
                    catch (IllegalAccessException e) {
                        System.out.println("Wrapper Manager: Unable to register shutdown hook: " + e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        System.out.println("Wrapper Manager: Unable to register shutdown hook: " + e.getMessage());
                    }
                }
                if ((WrapperManager.m_key = System.getProperty("wrapper.key")) == null) {
                    if (WrapperManager.m_debug) {
                        System.out.println("Wrapper Manager: Not using wrapper.  (key not specified)");
                    }
                    WrapperManager.m_port = 0;
                    WrapperManager.m_service = false;
                    WrapperManager.m_cpuTimeout = 31557600000L;
                } else {
                    if (WrapperManager.m_debug) {
                        System.out.println("Wrapper Manager: Using wrapper");
                    }
                    System.setIn(new WrapperInputStream());
                    sPort = System.getProperty("wrapper.port");
                    if (sPort == null) {
                        msg = WrapperManager.m_res.format("MISSING_PORT");
                        System.out.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                    try {
                        WrapperManager.m_port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        msg = WrapperManager.m_res.format("BAD_PORT", sPort);
                        System.out.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                    WrapperManager.m_service = System.getProperty("wrapper.service") != null;
                    sCPUTimeout = System.getProperty("wrapper.cpu.timeout");
                    if (sCPUTimeout == null) {
                        WrapperManager.m_cpuTimeout = 10000L;
                    } else {
                        try {
                            WrapperManager.m_cpuTimeout = (long)Integer.parseInt(sCPUTimeout) * 1000L;
                        }
                        catch (NumberFormatException e) {
                            msg = WrapperManager.m_res.format("BAD_CPU_TIMEOUT", sCPUTimeout);
                            System.out.println(msg);
                            throw new ExceptionInInitializerError(msg);
                        }
                    }
                }
                try {
                    System.loadLibrary("wrapper");
                    WrapperManager.m_libraryOK = true;
                    break block35;
                }
                catch (UnsatisfiedLinkError e) {
                    libPath = System.getProperty("java.library.path");
                    System.out.println();
                    if (libPath.equals("")) {
                        System.out.println("WARNING - Unable to load native library 'wrapper' because the");
                        System.out.println("          java.library.path was set to ''.  Please see the");
                        System.out.println("          documentation for the wrapper.java.library.path ");
                        System.out.println("          configuration property.");
                        break block36;
                    }
                    pathSep = System.getProperty("path.separator");
                    libFile = System.getProperty("os.name").indexOf("Windows") >= 0 ? "Wrapper.DLL" : "libwrapper.so";
                    libFileFound = false;
                    pathElement = null;
                    st = new StringTokenizer(libPath, pathSep);
                    ** while (st.hasMoreTokens())
                }
lbl-1000:
                // 1 sources

                {
                    pathElement = new File(new File(st.nextToken()), libFile);
                    if (!pathElement.exists()) continue;
                    libFileFound = true;
                    break;
                }
lbl118:
                // 2 sources

                if (libFileFound) {
                    System.out.println("WARNING - Unable to load native library '" + libFile + "'.  The file");
                    System.out.println("          is located on the path at the following location but could");
                    System.out.println("          not be loaded:");
                    System.out.println("            " + pathElement.getAbsolutePath());
                    System.out.println("          Please verify that the file is readable by the current user");
                    System.out.println("          and that the file has not been corrupted in any way.");
                } else {
                    System.out.println("WARNING - Unable to load native library 'wrapper' because the");
                    System.out.println("          file '" + libFile + "' could not be located in the following");
                    System.out.println("          java.library.path:");
                    st = new StringTokenizer(libPath, pathSep);
                    while (st.hasMoreTokens()) {
                        pathElement = new File(st.nextToken());
                        System.out.println("            " + pathElement.getAbsolutePath());
                    }
                    System.out.println("          Please see the documentation for the wrapper.java.library.path");
                    System.out.println("          configuration property.");
                }
            }
            System.out.println("          System signals will not be handled correctly.");
            System.out.println();
            WrapperManager.m_libraryOK = false;
        }
        if (WrapperManager.m_libraryOK) {
            if (WrapperManager.m_debug) {
                System.out.println("Calling native initialization method.");
            }
            WrapperManager.nativeInit(WrapperManager.m_debug);
        }
        WrapperManager.m_eventRunnerTime = System.currentTimeMillis();
        WrapperManager.m_eventRunner = new Thread("Wrapper-Control-Event-Monitor"){

            public void run() {
                while (!m_shuttingDown) {
                    int event;
                    long now = System.currentTimeMillis();
                    long age = now - m_eventRunnerTime;
                    if (age > m_cpuTimeout) {
                        System.out.println("JVM Process has not received any CPU time for " + age / 1000L + " seconds.  Extending timeouts.");
                        m_lastPing = now;
                    }
                    m_eventRunnerTime = now;
                    if (m_libraryOK && (event = WrapperManager.nativeGetControlEvent()) != 0) {
                        WrapperManager.controlEvent(event);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        };
        WrapperManager.m_eventRunner.setDaemon(true);
        WrapperManager.m_eventRunner.start();
        fullVersion = System.getProperty("java.fullversion");
        if (fullVersion == null) {
            fullVersion = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        WrapperManager.m_systemThreadCount = fullVersion.indexOf("JRockit") >= 0 ? 0 : 1;
        if (WrapperManager.m_debug) {
            System.out.println("Java Version   : " + fullVersion);
            System.out.println("Java VM Vendor : " + System.getProperty("java.vm.vendor"));
            System.out.println();
        }
        WrapperManager.m_instance = new WrapperManager();
    }

    private static class WrapperInputStream
    extends InputStream {
        private WrapperInputStream() {
        }

        public int read() throws IOException {
            throw new IOException("System.in can not be used when the JVM is being controlled by the Java Service Manager.");
        }
    }
}

