/*
 * Decompiled with CFR 0.152.
 */
package br.puc_rio.tecgraf.maven.plugin.dependency.template;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dependency-template", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DependencyTemplateMojo
extends AbstractMojo {
    protected static final String DEFAULT_ARTIFACT_TEMPLATE = "{{groupId}}:{{artifactId}}-{{version}}{{ifClassifier:-}}{{classifier}}.{{type}}";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter
    protected String mainTemplateFile;
    @Parameter
    protected String artifactTemplateFile;
    @Parameter(defaultValue="false")
    protected Boolean excludeTransitive;
    @Parameter
    protected List<String> excludeGroupIds;
    @Parameter
    protected List<String> excludeArtifactIds;
    @Parameter
    protected List<String> excludeClassifiers;
    @Parameter
    protected List<String> excludeTypes;
    @Parameter
    protected String outputFile;
    @Parameter
    protected String outputProperty;
    @Parameter(defaultValue="UTF-8")
    protected String charset;
    @Parameter
    protected String separator;
    @Parameter(defaultValue="true")
    protected Boolean lineBreak;

    public void execute() throws MojoExecutionException {
        block21: {
            try {
                String artifactTemplate = DEFAULT_ARTIFACT_TEMPLATE;
                if (this.artifactTemplateFile != null) {
                    byte[] bytes = Files.readAllBytes(Paths.get(this.artifactTemplateFile, new String[0]));
                    artifactTemplate = new String(bytes, this.charset);
                }
                Set unfilteredArtifacts = this.excludeTransitive != false ? this.mavenProject.getDependencyArtifacts() : this.mavenProject.getArtifacts();
                Set<String> excludeGroupIds = this.toSet(this.excludeGroupIds);
                Set<String> excludeArtifactIds = this.toSet(this.excludeArtifactIds);
                Set<String> excludeClassifiers = this.toSet(this.excludeClassifiers);
                Set<String> excludeTypes = this.toSet(this.excludeTypes);
                ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                for (Object obj : unfilteredArtifacts) {
                    Artifact artifact = (Artifact)obj;
                    if (!excludeGroupIds.isEmpty() && excludeGroupIds.contains(artifact.getGroupId()) || !excludeArtifactIds.isEmpty() && excludeArtifactIds.contains(artifact.getArtifactId()) || !excludeTypes.isEmpty() && excludeTypes.contains(artifact.getType()) || !excludeClassifiers.isEmpty() && artifact.getClassifier() != null && excludeClassifiers.contains(artifact.getClassifier())) continue;
                    artifacts.add(artifact);
                }
                this.getLog().info((CharSequence)("Artifact list size: " + artifacts.size()));
                Collections.sort(artifacts);
                String finalSeparator = "";
                if (this.separator != null) {
                    finalSeparator = finalSeparator + this.separator;
                }
                if (this.lineBreak.booleanValue()) {
                    finalSeparator = finalSeparator + "\n";
                }
                StringJoiner dependencyJoiner = new StringJoiner(finalSeparator);
                for (Artifact artifact : artifacts) {
                    String dependencyAsString = this.applyArtifactTemplate(artifact, artifactTemplate);
                    dependencyJoiner.add(dependencyAsString);
                }
                String mainTemplate = "{{artifacts}}";
                if (this.mainTemplateFile != null) {
                    byte[] bytes = Files.readAllBytes(Paths.get(this.mainTemplateFile, new String[0]));
                    mainTemplate = new String(bytes, this.charset);
                }
                mainTemplate = mainTemplate.replace("{{artifacts}}", dependencyJoiner.toString());
                if (this.outputProperty != null) {
                    System.setProperty(this.outputProperty, mainTemplate);
                    this.getLog().info((CharSequence)("Updated system property: " + this.outputProperty));
                }
                if (this.outputFile == null) break block21;
                Files.createDirectories(Paths.get(this.outputFile, new String[0]).getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFile));){
                    writer.write(mainTemplate);
                }
                this.getLog().info((CharSequence)("Generated file: " + this.outputFile));
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    private String applyArtifactTemplate(Artifact artifact, String template) {
        int lastIndex;
        String str = template;
        str = str.replace("{{groupId}}", artifact.getGroupId());
        str = str.replace("{{artifactId}}", artifact.getArtifactId());
        str = str.replace("{{version}}", artifact.getVersion());
        str = str.replace("{{type}}", artifact.getType());
        str = str.replace("{{scope}}", artifact.getScope());
        String classifier = artifact.getClassifier() != null ? artifact.getClassifier() : "";
        int firstIndex = (str = str.replace("{{classifier}}", classifier)).indexOf("{{ifClassifier:");
        if (firstIndex > -1 && (lastIndex = str.indexOf("}}", firstIndex + 15)) > -1) {
            String content = str.substring(firstIndex + 15, lastIndex);
            String replacement = classifier.isEmpty() ? "" : content + artifact.getClassifier();
            str = str.replace("{{ifClassifier:" + content + "}}", replacement);
        }
        return str;
    }

    private Set<String> toSet(List<String> list) {
        HashSet<String> set = new HashSet<String>();
        if (list != null) {
            for (String value : list) {
                if (value == null) continue;
                set.add(value.toLowerCase());
            }
        }
        return set;
    }
}

