/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonSchema.factories.ArraySchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.BooleanSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.IntegerSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.NullSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.NumberSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.ObjectSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.SchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.StringSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.factories.ValueTypeSchemaFactory;
import com.fasterxml.jackson.databind.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.databind.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.JsonSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.ValueTypeSchema;

public class SchemaFactoryWrapper
implements JsonFormatVisitorWrapper {
    private SchemaFactory delegate;
    protected FactoryProvider factoryProvider;
    protected SerializerProvider provider;
    protected SchemaProvider schemaProvider = new SchemaProvider();

    public SchemaFactoryWrapper() {
        this.factoryProvider = new FactoryProvider();
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        AnySchema anySchema = this.schemaProvider.AnySchema();
        this.delegate = this.factoryProvider.SchemaFactory(anySchema);
        return this.factoryProvider.AnySchemaFactory(this.delegate, anySchema);
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArraySchema arraySchema = this.schemaProvider.ArraySchema();
        this.delegate = this.factoryProvider.SchemaFactory(arraySchema);
        return this.factoryProvider.ArraySchemaFactory(this.delegate, arraySchema);
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        BooleanSchema booleanSchema = this.schemaProvider.BooleanSchema();
        this.delegate = this.factoryProvider.SchemaFactory(booleanSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.ValueTypeSchemaFactory(this.delegate, booleanSchema);
        return this.factoryProvider.BooleanSchemaFactory(valueTypeSchemaFactory, booleanSchema);
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType convertedType) {
        IntegerSchema integerSchema = this.schemaProvider.IntegerSchema();
        this.delegate = this.factoryProvider.SchemaFactory(integerSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.ValueTypeSchemaFactory(this.delegate, integerSchema);
        return this.factoryProvider.IntegerSchemaFactory(valueTypeSchemaFactory, integerSchema);
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        NullSchema nullSchema = this.schemaProvider.NullSchema();
        this.delegate = this.factoryProvider.SchemaFactory(nullSchema);
        return this.factoryProvider.NullSchemaFactory(this.delegate, nullSchema);
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        NumberSchema numberSchema = this.schemaProvider.NumberSchema();
        this.delegate = this.factoryProvider.SchemaFactory(numberSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.ValueTypeSchemaFactory(this.delegate, numberSchema);
        return this.factoryProvider.NumberSchemaFactory(valueTypeSchemaFactory, numberSchema);
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        ObjectSchema objectSchema = this.schemaProvider.ObjectSchema();
        this.delegate = this.factoryProvider.SchemaFactory(objectSchema);
        return this.factoryProvider.ObjectSchemaFactory(this.delegate, objectSchema);
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType convertedType) {
        StringSchema stringSchema = this.schemaProvider.StringSchema();
        this.delegate = this.factoryProvider.SchemaFactory(stringSchema);
        ValueTypeSchemaFactory valueTypeSchemaFactory = this.factoryProvider.ValueTypeSchemaFactory(this.delegate, stringSchema);
        return this.factoryProvider.StringSchemaFactory(valueTypeSchemaFactory, stringSchema);
    }

    public JsonSchema finalSchema() {
        assert (this.delegate != null) : "SchemaFactory must envoke a delegate method before it can return a JsonSchema.";
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getSchema();
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider provider) {
        this.provider = provider;
    }

    protected class SchemaProvider {
        protected SchemaProvider() {
        }

        public AnySchema AnySchema() {
            return new AnySchema();
        }

        public ArraySchema ArraySchema() {
            return new ArraySchema();
        }

        public BooleanSchema BooleanSchema() {
            return new BooleanSchema();
        }

        public IntegerSchema IntegerSchema() {
            return new IntegerSchema();
        }

        public NullSchema NullSchema() {
            return new NullSchema();
        }

        public NumberSchema NumberSchema() {
            return new NumberSchema();
        }

        public ObjectSchema ObjectSchema() {
            return new ObjectSchema();
        }

        public StringSchema StringSchema() {
            return new StringSchema();
        }
    }

    public class SchemaFactoryWrapperProvider {
        public SchemaFactoryWrapper SchemaFactoryWrapper() {
            SchemaFactoryWrapper wrapper = new SchemaFactoryWrapper();
            wrapper.setProvider(SchemaFactoryWrapper.this.getProvider());
            return wrapper;
        }
    }

    protected class FactoryProvider {
        SchemaFactoryWrapperProvider factoryWrapperProvider;

        public SchemaFactoryWrapperProvider getFactoryWrapperProvider() {
            return this.factoryWrapperProvider;
        }

        public void setFactoryWrapperProvider(SchemaFactoryWrapperProvider factoryWrapperProvider) {
            this.factoryWrapperProvider = factoryWrapperProvider;
        }

        public FactoryProvider() {
            this.factoryWrapperProvider = new SchemaFactoryWrapperProvider();
        }

        public JsonAnyFormatVisitor AnySchemaFactory(SchemaFactory delegate, AnySchema anySchema) {
            return null;
        }

        public JsonArrayFormatVisitor ArraySchemaFactory(SchemaFactory parent, ArraySchema arraySchema) {
            ArraySchemaFactory arraySchemaFactory = new ArraySchemaFactory(parent, arraySchema);
            arraySchemaFactory.setFactoryWrapperProvider(this.factoryWrapperProvider);
            return arraySchemaFactory;
        }

        public JsonBooleanFormatVisitor BooleanSchemaFactory(ValueTypeSchemaFactory parent, BooleanSchema booleanSchema) {
            return new BooleanSchemaFactory(parent, booleanSchema);
        }

        public JsonIntegerFormatVisitor IntegerSchemaFactory(ValueTypeSchemaFactory parent, IntegerSchema integerSchema) {
            return new IntegerSchemaFactory(parent, integerSchema);
        }

        public JsonNullFormatVisitor NullSchemaFactory(SchemaFactory parent, NullSchema nullSchema) {
            return new NullSchemaFactory(parent, nullSchema);
        }

        public JsonNumberFormatVisitor NumberSchemaFactory(ValueTypeSchemaFactory parent, NumberSchema numberSchema) {
            return new NumberSchemaFactory(parent, numberSchema);
        }

        public JsonObjectFormatVisitor ObjectSchemaFactory(SchemaFactory parent, ObjectSchema objectSchema) {
            ObjectSchemaFactory objectSchemaFactory = new ObjectSchemaFactory(parent, objectSchema);
            objectSchemaFactory.setFactoryWrapperProvider(this.factoryWrapperProvider);
            return objectSchemaFactory;
        }

        public SchemaFactory SchemaFactory(JsonSchema schema) {
            return new SchemaFactory(SchemaFactoryWrapper.this.provider, schema);
        }

        public JsonStringFormatVisitor StringSchemaFactory(ValueTypeSchemaFactory parent, StringSchema stringSchema) {
            return new StringSchemaFactory(parent, stringSchema);
        }

        public ValueTypeSchemaFactory ValueTypeSchemaFactory(SchemaFactory parent, ValueTypeSchema valueTypeSchema) {
            return new ValueTypeSchemaFactory(parent, valueTypeSchema);
        }
    }
}

