/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class SVD {
    protected DenseMatrix U;
    protected DenseMatrix V;
    protected double[] s;
    protected boolean full;
    protected int m;
    protected int n;
    protected double tol;

    public SVD(DenseMatrix U, DenseMatrix V, double[] s) {
        this.U = U;
        this.V = V;
        this.s = s;
        this.m = U.nrows();
        this.n = V.nrows();
        this.full = s.length == Math.min(this.m, this.n);
        this.tol = 0.5 * Math.sqrt((double)(this.m + this.n) + 1.0) * s[0] * Math.EPSILON;
    }

    public DenseMatrix getU() {
        return this.U;
    }

    public DenseMatrix getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DenseMatrix getS() {
        DenseMatrix S = Matrix.zeros(this.U.nrows(), this.V.nrows());
        for (int i = 0; i < this.s.length; ++i) {
            S.set(i, i, this.s[i]);
        }
        return S;
    }

    public double norm() {
        return this.s[0];
    }

    public int rank() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > this.tol)) continue;
            ++r;
        }
        return r;
    }

    public int nullity() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] <= this.tol)) continue;
            ++r;
        }
        return r;
    }

    public double condition() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        return this.s[0] <= 0.0 || this.s[this.n - 1] <= 0.0 ? Double.POSITIVE_INFINITY : this.s[0] / this.s[this.n - 1];
    }

    public DenseMatrix range() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nr = 0;
        DenseMatrix rnge = Matrix.zeros(this.m, this.rank());
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] > this.tol)) continue;
            for (int i = 0; i < this.m; ++i) {
                rnge.set(i, nr, this.U.get(i, j));
            }
            ++nr;
        }
        return rnge;
    }

    public DenseMatrix nullspace() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int nn = 0;
        DenseMatrix nullsp = Matrix.zeros(this.n, this.nullity());
        for (int j = 0; j < this.n; ++j) {
            if (!(this.s[j] <= this.tol)) continue;
            for (int jj = 0; jj < this.n; ++jj) {
                nullsp.set(jj, nn, this.V.get(jj, j));
            }
            ++nn;
        }
        return nullsp;
    }

    public Cholesky CholeskyOfAtA() {
        DenseMatrix VD = Matrix.zeros(this.V.nrows(), this.V.ncols());
        for (int i = 0; i < this.V.nrows(); ++i) {
            for (int j = 0; j < this.V.ncols(); ++j) {
                VD.set(i, j, this.V.get(i, j) * this.s[j]);
            }
        }
        return new Cholesky(VD.aat());
    }

    public void solve(double[] b, double[] x) {
        double r;
        int j;
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (b.length != this.m || x.length != this.n) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] tmp = new double[this.n];
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            if (this.s[j] > this.tol) {
                for (int i = 0; i < this.m; ++i) {
                    r += this.U.get(i, j) * b[i];
                }
                r /= this.s[j];
            }
            tmp[j] = r;
        }
        for (j = 0; j < this.n; ++j) {
            r = 0.0;
            for (int jj = 0; jj < this.n; ++jj) {
                r += this.V.get(j, jj) * tmp[jj];
            }
            x[j] = r;
        }
    }

    public void solve(DenseMatrix B) {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (B.nrows() != this.m) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] b = new double[this.m];
        double[] x = new double[this.n];
        int p = B.ncols();
        for (int j = 0; j < p; ++j) {
            int i;
            for (i = 0; i < this.m; ++i) {
                b[i] = B.get(i, j);
            }
            this.solve(b, x);
            for (i = 0; i < this.n; ++i) {
                B.set(i, j, x[i]);
            }
        }
    }
}

