/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.OrderedBatch;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ParallelCollectListIterable<T, V>
extends AbstractParallelListIterable<V, ListBatch<V>> {
    private final AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectListIterable(AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable, Function<? super T, ? extends V> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<V>> split() {
        return this.parallelIterable.split().collect(new Function<OrderedBatch<T>, ListBatch<V>>(){

            public ListBatch<V> valueOf(OrderedBatch<T> eachBatch) {
                return eachBatch.collect(ParallelCollectListIterable.this.function);
            }
        });
    }

    public void forEach(Procedure<? super V> procedure) {
        this.parallelIterable.forEach(Functions.bind(procedure, this.function));
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public V detect(Predicate<? super V> predicate) {
        Object resultItem = this.parallelIterable.detect(Predicates.attributePredicate(this.function, predicate));
        return (V)(resultItem == null ? null : this.function.valueOf(resultItem));
    }
}

