/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.list.immutable.AbstractImmutableList;
import java.io.Serializable;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableQuadrupletonList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    private final T element1;
    private final T element2;
    private final T element3;
    private final T element4;

    ImmutableQuadrupletonList(T obj1, T obj2, T obj3, T obj4) {
        this.element1 = obj1;
        this.element2 = obj2;
        this.element3 = obj3;
        this.element4 = obj4;
    }

    @Override
    public int size() {
        return 4;
    }

    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
        procedure.value(this.element2);
        procedure.value(this.element3);
        procedure.value(this.element4);
    }

    @Override
    public T get(int index) {
        switch (index) {
            case 0: {
                return this.element1;
            }
            case 1: {
                return this.element2;
            }
            case 2: {
                return this.element3;
            }
            case 3: {
                return this.element4;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.with(this.element1, this.element2, this.element3, this.element4, newItem);
    }
}

