/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.UnmodifiableRichIterable;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.tuple.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultimap<K, V, C extends RichIterable<V>>
implements Multimap<K, V> {
    private static final Function<AbstractMultimap<?, ?, ?>, ?> CREATE_COLLECTION_BLOCK = new Function<AbstractMultimap<?, ?, ?>, RichIterable<?>>(){

        public RichIterable<?> valueOf(AbstractMultimap<?, ?, ?> multimap) {
            return multimap.createCollection();
        }
    };

    protected abstract MapIterable<K, C> getMap();

    protected abstract C createCollection();

    protected Function<AbstractMultimap<K, V, C>, C> createCollectionBlock() {
        return CREATE_COLLECTION_BLOCK;
    }

    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsValue(final Object value) {
        return this.getMap().anySatisfy(new Predicate<C>(){

            public boolean accept(C collection) {
                return collection.contains(value);
            }
        });
    }

    public boolean containsKeyAndValue(Object key, Object value) {
        RichIterable collection = (RichIterable)this.getMap().get(key);
        return collection != null && collection.contains(value);
    }

    public RichIterable<K> keysView() {
        return this.getMap().keysView();
    }

    public RichIterable<RichIterable<V>> multiValuesView() {
        return this.getMap().valuesView().collect(new Function<C, RichIterable<V>>(){

            public RichIterable<V> valueOf(C multiValue) {
                return UnmodifiableRichIterable.of(multiValue);
            }
        });
    }

    public Bag<K> keyBag() {
        final MutableBag bag = Bags.mutable.empty();
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(K key, C value) {
                bag.addOccurrences(key, value.size());
            }
        });
        return bag;
    }

    /*
     * Exception decompiling
     */
    public RichIterable<V> valuesView() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RichIterable<Pair<K, RichIterable<V>>> keyMultiValuePairsView() {
        return this.getMap().keyValuesView().collect(new Function<Pair<K, C>, Pair<K, RichIterable<V>>>(){

            public Pair<K, RichIterable<V>> valueOf(Pair<K, C> pair) {
                return Tuples.pair(pair.getOne(), UnmodifiableRichIterable.of((RichIterable)pair.getTwo()));
            }
        });
    }

    public RichIterable<Pair<K, V>> keyValuePairsView() {
        return this.keyMultiValuePairsView().flatCollect(new Function<Pair<K, RichIterable<V>>, Iterable<Pair<K, V>>>(){

            public Iterable<Pair<K, V>> valueOf(Pair<K, RichIterable<V>> pair) {
                return ((RichIterable)pair.getTwo()).collect(new KeyValuePairFunction(pair.getOne()));
            }
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.getMap().equals((Object)that.toMap());
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public void forEachValue(final Procedure<? super V> procedure) {
        this.getMap().forEachValue(new Procedure<C>(){

            public void value(C collection) {
                collection.forEach(procedure);
            }
        });
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.getMap().forEachKey(procedure);
    }

    public void forEachKeyValue(final Procedure2<K, V> procedure) {
        final Procedure2 innerProcedure = new Procedure2<V, K>(){

            public void value(V value, K key) {
                procedure.value(key, value);
            }
        };
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(K key, C collection) {
                collection.forEachWith(innerProcedure, key);
            }
        });
    }

    public void forEachKeyMultiValues(Procedure2<K, ? super Iterable<V>> procedure) {
        this.getMap().forEachKeyValue(procedure);
    }

    public <R extends MutableMultimap<K, V>> R selectKeysValues(final Predicate2<? super K, ? super V> predicate, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(final K key, C collection) {
                RichIterable selectedValues = collection.select(new Predicate<V>(){

                    public boolean accept(V value) {
                        return predicate.accept(key, value);
                    }
                });
                target.putAll(key, (Iterable)selectedValues);
            }
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R rejectKeysValues(final Predicate2<? super K, ? super V> predicate, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(final K key, C collection) {
                RichIterable selectedValues = collection.reject(new Predicate<V>(){

                    public boolean accept(V value) {
                        return predicate.accept(key, value);
                    }
                });
                target.putAll(key, (Iterable)selectedValues);
            }
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R selectKeysMultiValues(final Predicate2<? super K, ? super Iterable<V>> predicate, final R target) {
        this.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            public void value(K key, Iterable<V> collection) {
                if (predicate.accept(key, collection)) {
                    target.putAll(key, collection);
                }
            }
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R rejectKeysMultiValues(final Predicate2<? super K, ? super Iterable<V>> predicate, final R target) {
        this.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            public void value(K key, Iterable<V> collection) {
                if (!predicate.accept(key, collection)) {
                    target.putAll(key, collection);
                }
            }
        });
        return target;
    }

    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeysValues(final Function2<? super K, ? super V, Pair<K2, V2>> function, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(final K key, C collection) {
                collection.forEach(new Procedure<V>(){

                    public void value(V value) {
                        Pair pair = (Pair)function.value(key, value);
                        target.add(pair);
                    }
                });
            }
        });
        return target;
    }

    public <V2, R extends MutableMultimap<K, V2>> R collectValues(final Function<? super V, ? extends V2> function, final R target) {
        this.getMap().forEachKeyValue(new Procedure2<K, C>(){

            public void value(K key, C collection) {
                target.putAll(key, (Iterable)collection.collect(function));
            }
        });
        return target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyValuePairFunction<V, K>
    implements Function<V, Pair<K, V>> {
        private static final long serialVersionUID = 1L;
        private final K key;

        private KeyValuePairFunction(K key) {
            this.key = key;
        }

        public Pair<K, V> valueOf(V value) {
            return Tuples.pair(this.key, value);
        }
    }
}

