/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableFloatSetFactory;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableFloatEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableFloatSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;

public class ImmutableFloatSetFactoryImpl
implements ImmutableFloatSetFactory {
    public ImmutableFloatSet empty() {
        return ImmutableFloatEmptySet.INSTANCE;
    }

    public ImmutableFloatSet of() {
        return this.empty();
    }

    public ImmutableFloatSet with() {
        return this.empty();
    }

    public ImmutableFloatSet of(float one) {
        return this.with(one);
    }

    public ImmutableFloatSet with(float one) {
        return new ImmutableFloatSingletonSet(one);
    }

    public ImmutableFloatSet of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatSet with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return FloatHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableFloatSet ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatSet withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatSet) {
            return (ImmutableFloatSet)items;
        }
        return this.with(items.toArray());
    }
}

