/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.lazy.primitive.CollectBooleanToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectBooleanIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyBooleanIterate {
    private static final LazyBooleanIterable EMPTY_ITERABLE = BooleanLists.immutable.of().asLazy();

    private LazyBooleanIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyBooleanIterable adapt(BooleanIterable iterable) {
        return new LazyBooleanIterableAdapter(iterable);
    }

    public static LazyBooleanIterable select(BooleanIterable iterable, BooleanPredicate predicate) {
        return new SelectBooleanIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(BooleanIterable iterable, BooleanToObjectFunction<? extends V> function) {
        return new CollectBooleanToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(BooleanIterable iterable, BooleanPredicate predicate, BooleanToObjectFunction<? extends V> function) {
        return LazyBooleanIterate.select(iterable, predicate).collect(function);
    }

    public static LazyBooleanIterable empty() {
        return EMPTY_ITERABLE;
    }
}

