/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMapBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.NonSerializableForwardingCollection;
import com.google.common.collect.NonSerializableForwardingSet;
import com.google.common.collect.StandardBiMap;
import com.google.common.collect.Synchronized;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maps {
    private static final BiMap<Object, Object> EMPTY_BIMAP = new EmptyBiMap();
    private static final MapConstraint<Class<?>, Object> VALUE_CAN_BE_CAST_TO_KEY = new MapConstraint<Class<?>, Object>(){

        @Override
        public void checkKeyValue(Class<?> key, Object value) {
            Maps.wrap(key).cast(value);
        }
    };
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder<Class<Boolean>, Class<Boolean>>().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();

    private Maps() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0);
        return Math.max(expectedSize * 2, 16);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(@Nullable Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        return new EnumMap(type);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static boolean containsEntry(Map<?, ?> map, @Nullable Object key, @Nullable Object value) {
        Object valueForKey = map.get(key);
        return valueForKey == null ? value == null && map.containsKey(key) : valueForKey.equals(value);
    }

    public static <K, V> BiMap<K, V> immutableBiMap() {
        return EMPTY_BIMAP;
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable K k1, @Nullable V v1) {
        return new ImmutableBiMapBuilder<K, V>().put(k1, v1).getBiMap();
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2) {
        return new ImmutableBiMapBuilder<K, V>().put(k1, v1).put(k2, v2).getBiMap();
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3) {
        return new ImmutableBiMapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).getBiMap();
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3, @Nullable K k4, @Nullable V v4) {
        return new ImmutableBiMapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).getBiMap();
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3, @Nullable K k4, @Nullable V v4, @Nullable K k5, @Nullable V v5) {
        return new ImmutableBiMapBuilder<K, V>().put(k1, v1).put(k2, v2).put(k3, v3).put(k4, v4).put(k5, v5).getBiMap();
    }

    public static <K, V> BiMap<K, V> synchronizedBiMap(BiMap<K, V> bimap) {
        return Synchronized.biMap(bimap, null);
    }

    public static <K, V> SortedSet<K> sortedKeySet(SortedMap<K, V> map) {
        return new SortedMapKeySet<K, V>(map);
    }

    public static <K, V> Map<K, V> uniqueIndex(Iterable<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        HashMap newMap;
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            newMap = new HashMap(collection.size());
        } else {
            newMap = new HashMap();
        }
        return Maps.uniqueIndex(newMap, values.iterator(), keyFunction);
    }

    public static <K, V> Map<K, V> uniqueIndex(Collection<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        return Maps.uniqueIndex(new HashMap(Maps.capacity(values.size())), values.iterator(), keyFunction);
    }

    public static <K, V> Map<K, V> uniqueIndex(Iterator<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        return Maps.uniqueIndex(new HashMap(), values, keyFunction);
    }

    private static <K, V> Map<K, V> uniqueIndex(Map<K, V> map, Iterator<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        Preconditions.checkNotNull(keyFunction);
        while (values.hasNext()) {
            V value = Preconditions.checkNotNull(values.next(), "null index values not allowed");
            K key = Preconditions.checkNotNull(keyFunction.apply(value), "null index keys not allowed");
            Preconditions.checkArgument(map.put(key, value) == null, "Duplicate key: %s", key);
        }
        return map;
    }

    public static Map<String, String> fromProperties(Properties properties) {
        HashMap<String, String> ret = Maps.newHashMapWithExpectedSize(properties.size());
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            String key = k != null ? k.toString() : null;
            ret.put(key, properties.getProperty(key));
        }
        return ret;
    }

    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    static <K, V> Set<Map.Entry<K, V>> unmodifiableEntrySet(Set<Map.Entry<K, V>> entrySet) {
        return new UnmodifiableEntrySet<K, V>(Collections.unmodifiableSet(entrySet));
    }

    private static <K, V> Map.Entry<K, V> unmodifiableEntry(final Map.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }
        };
    }

    public static <K, V> HashBiMap<K, V> newHashBiMap() {
        return new HashBiMap();
    }

    public static <K extends Enum<K>, V> EnumHashBiMap<K, V> newEnumHashBiMap(Class<K> keyType) {
        return new EnumHashBiMap(keyType);
    }

    public static <K extends Enum<K>, V extends Enum<V>> EnumBiMap<K, V> newEnumBiMap(Class<K> keyType, Class<V> valueType) {
        return new EnumBiMap<K, V>(keyType, valueType);
    }

    public static <K, V> BiMap<K, V> newBiMap(Map<K, V> forward, Map<V, K> backward) {
        return new StandardBiMap<K, V>(forward, backward);
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(BiMap<K, V> bimap) {
        return new UnmodifiableBiMap<K, V>(bimap, null);
    }

    public static <B> ClassToInstanceMap<B> newClassToInstanceMap() {
        return Maps.newClassToInstanceMap(new HashMap());
    }

    public static <B> ClassToInstanceMap<B> newClassToInstanceMap(Map<Class<? extends B>, B> backingMap) {
        return new SimpleClassToInstanceMap<B>(backingMap);
    }

    private static <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }

    static <K, V> boolean containsEntryImpl(Collection<Map.Entry<K, V>> c, Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        return c.contains(Maps.unmodifiableEntry((Map.Entry)o));
    }

    static <K, V> boolean removeEntryImpl(Collection<Map.Entry<K, V>> c, Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        return c.remove(Maps.unmodifiableEntry((Map.Entry)o));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleClassToInstanceMap<B>
    extends MapConstraints.ConstrainedMap<Class<? extends B>, B>
    implements ClassToInstanceMap<B> {
        private static final long serialVersionUID = 3549975116715378971L;

        SimpleClassToInstanceMap(Map<Class<? extends B>, B> delegate) {
            super(delegate, VALUE_CAN_BE_CAST_TO_KEY);
        }

        @Override
        public <T extends B> T putInstance(Class<T> type, T value) {
            T oldValue = this.put(type, value);
            return Maps.wrap(type).cast(oldValue);
        }

        @Override
        public <T extends B> T getInstance(Class<T> type) {
            Object value = this.get(type);
            return Maps.wrap(type).cast(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableBiMap<K, V>
    extends ForwardingMap<K, V>
    implements BiMap<K, V> {
        final BiMap<K, V> delegate;
        volatile transient BiMap<V, K> inverse;
        private static final long serialVersionUID = 9106827410356097381L;

        UnmodifiableBiMap(BiMap<K, V> delegate, BiMap<V, K> inverse) {
            super(Collections.unmodifiableMap(delegate));
            this.delegate = delegate;
            this.inverse = inverse;
        }

        @Override
        public V forcePut(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BiMap<V, K> inverse() {
            if (this.inverse == null) {
                this.inverse = new UnmodifiableBiMap<K, V>(this.delegate.inverse(), this);
            }
            return this.inverse;
        }

        @Override
        public Set<V> values() {
            return Collections.unmodifiableSet(this.delegate.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableEntrySet<K, V>
    extends UnmodifiableEntries<K, V>
    implements Set<Map.Entry<K, V>> {
        UnmodifiableEntrySet(Set<Map.Entry<K, V>> entries) {
            super(entries);
        }

        @Override
        public boolean equals(Object o) {
            return ForwardingSet.equalsImpl(this, o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableEntries<K, V>
    extends NonSerializableForwardingCollection<Map.Entry<K, V>> {
        UnmodifiableEntries(Collection<Map.Entry<K, V>> entries) {
            super(entries);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ForwardingIterator<Map.Entry<K, V>>(super.iterator()){

                @Override
                public Map.Entry<K, V> next() {
                    return Maps.unmodifiableEntry((Map.Entry)super.next());
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ForwardingCollection.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ForwardingCollection.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ForwardingCollection.containsAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableEntry<K, V>
    extends AbstractMapEntry<K, V>
    implements Serializable {
        final K key;
        final V value;
        private static final long serialVersionUID = 8715539841043489689L;

        ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortedMapKeySet<K, V>
    extends NonSerializableForwardingSet<K>
    implements SortedSet<K> {
        final SortedMap<K, V> map;

        SortedMapKeySet(SortedMap<K, V> map) {
            super(map.keySet());
            this.map = map;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return new SortedMapKeySet<K, V>(this.map.headMap(toElement));
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return new SortedMapKeySet<K, V>(this.map.subMap(fromElement, toElement));
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return new SortedMapKeySet<K, V>(this.map.tailMap(fromElement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyBiMap
    extends ForwardingMap<Object, Object>
    implements BiMap<Object, Object> {
        private static final long serialVersionUID = 0L;

        public EmptyBiMap() {
            super(ImmutableMap.of());
        }

        @Override
        public Set<Object> values() {
            return Collections.emptySet();
        }

        @Override
        public Object forcePut(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BiMap<Object, Object> inverse() {
            return this;
        }

        private Object readResolve() {
            return EMPTY_BIMAP;
        }
    }
}

