/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpHeaderMap
implements IHasSize,
ICommonsIterable<Map.Entry<String, ICommonsList<String>>>,
ICloneable<HttpHeaderMap>,
IClearable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderMap.class);
    private final ICommonsOrderedMap<String, ICommonsList<String>> m_aHeaders = new CommonsLinkedHashMap<String, ICommonsList<String>>();

    public HttpHeaderMap() {
    }

    public HttpHeaderMap(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull(httpHeaderMap, "Other");
        this.m_aHeaders.putAll(httpHeaderMap.m_aHeaders);
    }

    @Nonnull
    public static String getUnifiedValue(@Nullable String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringHelper.replaceMultipleTo(string, new char[]{'\r', '\n', '\t'}, ' ', stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return this.m_aHeaders.removeAll();
    }

    @Nullable
    @ReturnsMutableObject
    private Map.Entry<String, ICommonsList<String>> _getHeaderEntry(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (Map.Entry<String, ICommonsList<String>> entry : this.m_aHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableObject
    private ICommonsList<String> _getHeaderList(@Nullable String string) {
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntry(string);
        return entry == null ? null : entry.getValue();
    }

    @Nonnull
    @ReturnsMutableObject
    private ICommonsList<String> _getOrCreateHeaderList(@Nonnull @Nonempty String string) {
        ICommonsList<String> iCommonsList = this._getHeaderList(string);
        if (iCommonsList == null) {
            iCommonsList = new CommonsArrayList<int>(2);
            this.m_aHeaders.put(string, iCommonsList);
        }
        return iCommonsList;
    }

    @Nonnull
    private EChange _setHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting HTTP header: '" + string + "' = '" + string2 + "'");
        }
        return this._getOrCreateHeaderList(string).set(string2);
    }

    @Nonnull
    private EChange _addHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding HTTP header: '" + string + "' = '" + string2 + "'");
        }
        return this._getOrCreateHeaderList(string).addObject(string2);
    }

    public void setHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this._setHeader(string, string2);
        }
    }

    public void addHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this._addHeader(string, string2);
        }
    }

    @Nonnull
    public static String getDateTimeAsString(@Nonnull ZonedDateTime zonedDateTime) {
        ValueEnforcer.notNull(zonedDateTime, "DateTime");
        return PDTWebDateHelper.getAsStringRFC822(zonedDateTime);
    }

    @Nonnull
    public static String getDateTimeAsString(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "DateTime");
        return PDTWebDateHelper.getAsStringRFC822(localDateTime);
    }

    public void setDateHeader(@Nonnull @Nonempty String string, long l) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime(l));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDate localDate) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime(localDate));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime(localDateTime));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull ZonedDateTime zonedDateTime) {
        this._setHeader(string, HttpHeaderMap.getDateTimeAsString(zonedDateTime));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, long l) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime(l));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDate localDate) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime(localDate));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime(localDateTime));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull ZonedDateTime zonedDateTime) {
        this._addHeader(string, HttpHeaderMap.getDateTimeAsString(zonedDateTime));
    }

    public void setIntHeader(@Nonnull @Nonempty String string, int n) {
        this._setHeader(string, Integer.toString(n));
    }

    public void addIntHeader(@Nonnull @Nonempty String string, int n) {
        this._addHeader(string, Integer.toString(n));
    }

    public void setLongHeader(@Nonnull @Nonempty String string, long l) {
        this._setHeader(string, Long.toString(l));
    }

    public void addLongHeader(@Nonnull @Nonempty String string, long l) {
        this._addHeader(string, Long.toString(l));
    }

    public void setAllHeaders(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull(httpHeaderMap, "Other");
        for (Map.Entry entry : httpHeaderMap.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            this.removeHeaders(string);
            for (String string2 : (ICommonsList)entry.getValue()) {
                this.addHeader(string, string2);
            }
        }
    }

    public void addAllHeaders(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull(httpHeaderMap, "Other");
        for (Map.Entry entry : httpHeaderMap.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                this.addHeader(string, string2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ICommonsList<String>> getAllHeaders() {
        return this.m_aHeaders.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllHeaderNames() {
        return this.m_aHeaders.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderValues(@Nullable String string) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.hasText(string) && (iCommonsList = this._getHeaderList(string)) != null) {
            return (ICommonsList)iCommonsList.getClone();
        }
        return new CommonsArrayList<String>();
    }

    @Nullable
    public String getFirstHeaderValue(@Nullable String string) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.hasText(string) && (iCommonsList = this._getHeaderList(string)) != null) {
            return iCommonsList.getFirst();
        }
        return null;
    }

    @Nullable
    public String getHeaderCombined(@Nullable String string, @Nonnull String string2) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.hasText(string) && (iCommonsList = this._getHeaderList(string)) != null) {
            return StringHelper.getImploded(string2, iCommonsList);
        }
        return null;
    }

    public boolean containsHeaders(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this._getHeaderList(string) != null;
    }

    @Nonnull
    public EChange removeHeadersIf(@Nonnull Predicate<? super String> predicate) {
        return this.m_aHeaders.removeIfKey(predicate);
    }

    @Nonnull
    public EChange removeHeaders(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntry(string);
        if (entry != null) {
            return this.m_aHeaders.removeObject(entry.getKey());
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeHeader(@Nullable String string, @Nullable String string2) {
        boolean bl;
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntry(string);
        boolean bl2 = bl = entry != null && entry.getValue().remove(string2);
        if (bl && entry.getValue().isEmpty()) {
            this.m_aHeaders.remove(entry.getKey());
        }
        return EChange.valueOf(bl);
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, ICommonsList<String>>> iterator() {
        return this.m_aHeaders.entrySet().iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aHeaders.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aHeaders.isEmpty();
    }

    public void forEachSingleHeader(@Nonnull BiConsumer<? super String, ? super String> biConsumer) {
        for (Map.Entry entry : this.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                String string3 = HttpHeaderMap.getUnifiedValue(string2);
                biConsumer.accept(string, string3);
            }
        }
    }

    public void forEachHeaderLine(@Nonnull Consumer<? super String> consumer) {
        for (Map.Entry entry : this.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                String string3 = string + ": " + HttpHeaderMap.getUnifiedValue(string2);
                consumer.accept(string3);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderLines() {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        this.forEachHeaderLine(commonsArrayList::add);
        return commonsArrayList;
    }

    public void setContentLength(long l) {
        this._setHeader("Content-Length", Long.toString(l));
    }

    public void setContentType(@Nonnull String string) {
        this._setHeader("Content-Type", string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getClone() {
        return new HttpHeaderMap(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpHeaderMap httpHeaderMap = (HttpHeaderMap)object;
        return this.m_aHeaders.equals(httpHeaderMap.m_aHeaders);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aHeaders)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Headers", this.m_aHeaders).getToString();
    }
}

