/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.discovery;

import com.nepxion.discovery.plugin.framework.listener.discovery.AbstractDiscoveryListener;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;

public class ZoneFilterDiscoveryListener
extends AbstractDiscoveryListener {
    @Value(value="${spring.application.zone.route.enabled:true}")
    protected Boolean zoneRouteEnabled;

    @Override
    public void onGetInstances(String serviceId, List<ServiceInstance> instances) {
        this.applyZoneFilter(serviceId, instances);
    }

    private void applyZoneFilter(String providerServiceId, List<ServiceInstance> instances) {
        String zone = this.pluginAdapter.getZone();
        if (StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            return;
        }
        boolean validated = this.validate(instances, zone);
        Iterator<ServiceInstance> iterator = instances.iterator();
        while (iterator.hasNext()) {
            ServiceInstance instance = iterator.next();
            String instanceZone = this.pluginAdapter.getInstanceZone(instance);
            if (validated) {
                if (StringUtils.equals((CharSequence)instanceZone, (CharSequence)zone)) continue;
                iterator.remove();
                continue;
            }
            if (this.zoneRouteEnabled.booleanValue() || StringUtils.equals((CharSequence)instanceZone, (CharSequence)zone)) continue;
            iterator.remove();
        }
    }

    private boolean validate(List<ServiceInstance> instances, String zone) {
        for (ServiceInstance instance : instances) {
            String instanceZone = this.pluginAdapter.getInstanceZone(instance);
            if (!StringUtils.equals((CharSequence)instanceZone, (CharSequence)zone)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onGetServices(List<String> services) {
    }

    @Override
    public int getOrder() {
        return -2147483645;
    }
}

