/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.core;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.nepxion.eventbus.core.EventController;
import com.nepxion.eventbus.core.EventControllerImpl;
import com.nepxion.eventbus.core.EventType;
import com.nepxion.eventbus.thread.ThreadPoolFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;

public final class EventControllerFactory {
    @Autowired
    private ThreadPoolFactory threadPoolFactory;
    private volatile Map<String, EventController> syncControllerMap = new ConcurrentHashMap<String, EventController>();
    private volatile Map<String, EventController> asyncControllerMap = new ConcurrentHashMap<String, EventController>();

    public EventController getAsyncController() {
        return this.getAsyncController("SharedController");
    }

    public EventController getAsyncController(String identifier) {
        return this.getController(identifier, true);
    }

    public EventController getSyncController() {
        return this.getSyncController("SharedController");
    }

    public EventController getSyncController(String identifier) {
        return this.getController(identifier, false);
    }

    public EventController getController(String identifier, boolean async) {
        return this.getController(identifier, async ? EventType.ASYNC : EventType.SYNC);
    }

    public EventController getController(String identifier, EventType type) {
        switch (type) {
            case SYNC: {
                EventController newEventController;
                EventController syncEventController = this.syncControllerMap.get(identifier);
                if (syncEventController == null && (syncEventController = this.syncControllerMap.putIfAbsent(identifier, newEventController = this.createSyncController(identifier))) == null) {
                    syncEventController = newEventController;
                }
                return syncEventController;
            }
            case ASYNC: {
                EventController newEventController;
                EventController asyncEventController = this.asyncControllerMap.get(identifier);
                if (asyncEventController == null && (asyncEventController = this.asyncControllerMap.putIfAbsent(identifier, newEventController = this.createAsyncController(identifier, this.threadPoolFactory.getThreadPoolExecutor(identifier)))) == null) {
                    asyncEventController = newEventController;
                }
                return asyncEventController;
            }
        }
        return null;
    }

    public EventController createSyncController() {
        return new EventControllerImpl(new EventBus());
    }

    public EventController createSyncController(String identifier) {
        return new EventControllerImpl(new EventBus(identifier));
    }

    public EventController createSyncController(SubscriberExceptionHandler subscriberExceptionHandler) {
        return new EventControllerImpl(new EventBus(subscriberExceptionHandler));
    }

    public EventController createAsyncController(String identifier, Executor executor) {
        return new EventControllerImpl((EventBus)new AsyncEventBus(identifier, executor));
    }

    public EventController createAsyncController(Executor executor, SubscriberExceptionHandler subscriberExceptionHandler) {
        return new EventControllerImpl((EventBus)new AsyncEventBus(executor, subscriberExceptionHandler));
    }

    public EventController createAsyncController(Executor executor) {
        return new EventControllerImpl((EventBus)new AsyncEventBus(executor));
    }
}

