/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.thread;

import com.nepxion.eventbus.thread.entity.ThreadCustomization;
import com.nepxion.eventbus.thread.entity.ThreadParameter;
import com.nepxion.eventbus.thread.entity.ThreadQueueType;
import com.nepxion.eventbus.thread.entity.ThreadRejectedPolicyType;
import com.nepxion.eventbus.thread.policy.AbortPolicyWithReport;
import com.nepxion.eventbus.thread.policy.BlockingPolicyWithReport;
import com.nepxion.eventbus.thread.policy.CallerRunsPolicyWithReport;
import com.nepxion.eventbus.thread.policy.DiscardedPolicyWithReport;
import com.nepxion.eventbus.thread.policy.RejectedPolicyWithReport;
import com.nepxion.eventbus.thread.util.NetUtil;
import com.nepxion.eventbus.thread.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolFactory.class);
    private volatile Map<String, ThreadPoolExecutor> threadPoolExecutorMap = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private ThreadPoolExecutor threadPoolExecutor;
    private ThreadCustomization threadCustomization;
    private ThreadParameter threadParameter;

    public ThreadPoolFactory(ThreadCustomization threadCustomization, ThreadParameter threadParameter) {
        this.threadCustomization = threadCustomization;
        this.threadParameter = threadParameter;
    }

    public ThreadPoolExecutor getThreadPoolExecutor(String threadPoolName) {
        boolean threadPoolMultiMode = this.threadCustomization.isThreadPoolMultiMode();
        String poolName = this.createThreadPoolName(threadPoolName);
        if (threadPoolMultiMode) {
            ThreadPoolExecutor newThreadPoolExecutor;
            ThreadPoolExecutor threadPoolExecutor = this.threadPoolExecutorMap.get(poolName);
            if (threadPoolExecutor == null && (threadPoolExecutor = this.threadPoolExecutorMap.putIfAbsent(poolName, newThreadPoolExecutor = this.createThreadPoolExecutor(poolName))) == null) {
                threadPoolExecutor = newThreadPoolExecutor;
            }
            return threadPoolExecutor;
        }
        return this.createSharedThreadPoolExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ThreadPoolExecutor createSharedThreadPoolExecutor() {
        String threadPoolSharedName = this.threadCustomization.getThreadPoolSharedName();
        if (StringUtils.isEmpty((CharSequence)threadPoolSharedName)) {
            threadPoolSharedName = "SharedThreadPool";
        }
        String poolName = this.createThreadPoolName(threadPoolSharedName);
        if (this.threadPoolExecutor != null) return this.threadPoolExecutor;
        Class<ThreadPoolFactory> clazz = ThreadPoolFactory.class;
        synchronized (ThreadPoolFactory.class) {
            if (this.threadPoolExecutor != null) return this.threadPoolExecutor;
            this.threadPoolExecutor = this.createThreadPoolExecutor(poolName);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.threadPoolExecutor;
        }
    }

    private String createThreadPoolName(String threadPoolName) {
        boolean threadPoolNameIPShown = this.threadCustomization.isThreadPoolNameIPShown();
        return threadPoolNameIPShown ? StringUtil.firstLetterToUpper(threadPoolName) + "-" + NetUtil.getLocalHost() + "-thread" : StringUtil.firstLetterToUpper(threadPoolName) + "-thread";
    }

    private ThreadPoolExecutor createThreadPoolExecutor(String threadPoolName) {
        boolean threadPoolNameCustomized = this.threadCustomization.isThreadPoolNameCustomized();
        return threadPoolNameCustomized ? ThreadPoolFactory.createThreadPoolExecutor(threadPoolName, this.threadParameter) : ThreadPoolFactory.createThreadPoolExecutor(this.threadParameter);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(final String threadPoolName, ThreadParameter threadParameter) {
        int corePoolSize = threadParameter.getThreadPoolCorePoolSize();
        int maximumPoolSize = threadParameter.getThreadPoolMaximumPoolSize();
        long keepAliveTime = threadParameter.getThreadPoolKeepAliveTime();
        boolean allowCoreThreadTimeout = threadParameter.isThreadPoolAllowCoreThreadTimeout();
        String queue = threadParameter.getThreadPoolQueue();
        int queueCapacity = threadParameter.getThreadPoolQueueCapacity();
        String rejectedPolicy = threadParameter.getThreadPoolRejectedPolicy();
        LOG.info("Thread pool executor is created, threadPoolName={}, threadParameter={}", (Object)threadPoolName, (Object)threadParameter);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, ThreadPoolFactory.createBlockingQueue(queue, queueCapacity), new ThreadFactory(){
            private AtomicInteger number = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, threadPoolName + "-" + this.number.getAndIncrement());
            }
        }, ThreadPoolFactory.createRejectedPolicy(rejectedPolicy));
        threadPoolExecutor.allowCoreThreadTimeOut(allowCoreThreadTimeout);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(ThreadParameter threadParameter) {
        int corePoolSize = threadParameter.getThreadPoolCorePoolSize();
        int maximumPoolSize = threadParameter.getThreadPoolMaximumPoolSize();
        long keepAliveTime = threadParameter.getThreadPoolKeepAliveTime();
        boolean allowCoreThreadTimeout = threadParameter.isThreadPoolAllowCoreThreadTimeout();
        String queue = threadParameter.getThreadPoolQueue();
        int queueCapacity = threadParameter.getThreadPoolQueueCapacity();
        String rejectedPolicy = threadParameter.getThreadPoolRejectedPolicy();
        LOG.info("Thread pool executor is created, threadParameter={}", (Object)threadParameter);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, ThreadPoolFactory.createBlockingQueue(queue, queueCapacity), ThreadPoolFactory.createRejectedPolicy(rejectedPolicy));
        threadPoolExecutor.allowCoreThreadTimeOut(allowCoreThreadTimeout);
        return threadPoolExecutor;
    }

    private static BlockingQueue<Runnable> createBlockingQueue(String queue, int queueCapacity) {
        ThreadQueueType queueType = ThreadQueueType.fromString(queue);
        switch (queueType) {
            case LINKED_BLOCKING_QUEUE: {
                return new LinkedBlockingQueue<Runnable>(queueCapacity);
            }
            case ARRAY_BLOCKING_QUEUE: {
                return new ArrayBlockingQueue<Runnable>(queueCapacity);
            }
            case SYNCHRONOUS_QUEUE: {
                return new SynchronousQueue<Runnable>();
            }
        }
        return null;
    }

    private static RejectedExecutionHandler createRejectedPolicy(String rejectedPolicy) {
        ThreadRejectedPolicyType rejectedPolicyType = ThreadRejectedPolicyType.fromString(rejectedPolicy);
        switch (rejectedPolicyType) {
            case BLOCKING_POLICY_WITH_REPORT: {
                return new BlockingPolicyWithReport();
            }
            case CALLER_RUNS_POLICY_WITH_REPORT: {
                return new CallerRunsPolicyWithReport();
            }
            case ABORT_POLICY_WITH_REPORT: {
                return new AbortPolicyWithReport();
            }
            case REJECTED_POLICY_WITH_REPORT: {
                return new RejectedPolicyWithReport();
            }
            case DISCARDED_POLICY_WITH_REPORT: {
                return new DiscardedPolicyWithReport();
            }
        }
        return null;
    }

    public void shutdown() {
        if (this.threadPoolExecutor != null && !this.threadPoolExecutor.isShutdown()) {
            LOG.info("Shutting down thread pool executor [{}]...", (Object)this.threadPoolExecutor);
            this.threadPoolExecutor.shutdown();
        }
        for (Map.Entry<String, ThreadPoolExecutor> entry : this.threadPoolExecutorMap.entrySet()) {
            ThreadPoolExecutor executor = entry.getValue();
            if (executor == null || executor.isShutdown()) continue;
            LOG.info("Shutting down thread pool executor [{}] ...", (Object)this.threadPoolExecutor);
            executor.shutdown();
        }
    }
}

