/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.SessionManager;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpRunner
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SftpRunner.class);
    private static final String CHANNEL_SFTP = "sftp";
    private final SessionManager sessionManager;

    public SftpRunner(SessionFactory sessionFactory) {
        this.sessionManager = new SessionManager(sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Sftp sftp) throws JSchException, IOException {
        logger.debug("executing sftp command on {}", (Object)this.sessionManager);
        ChannelSftp channelSftp = null;
        try {
            channelSftp = (ChannelSftp)this.sessionManager.getSession().openChannel(CHANNEL_SFTP);
            channelSftp.connect();
            sftp.run(channelSftp);
        }
        finally {
            if (channelSftp != null) {
                channelSftp.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.sessionManager.close();
    }

    public static interface Sftp {
        public void run(ChannelSftp var1) throws JSchException, IOException;
    }
}

