/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.fingerprint;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.fingerprint.File;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.util.ByteSequence;
import org.apache.commons.io.IOUtils;

public class ClassFile
extends File {
    public ClassFile(byte[] bytes, String fileName) throws IOException {
        super(ClassFile.normalize(bytes, fileName), fileName);
    }

    public ClassFile(InputStream is, String fileName) throws IOException {
        this(IOUtils.toByteArray((InputStream)is), fileName);
    }

    public static String constantValue(int index, ConstantPool cp) {
        Constant type = cp.getConstant(index);
        if (type != null) {
            switch (type.getTag()) {
                case 7: {
                    ConstantClass cls = (ConstantClass)type;
                    return ClassFile.constantValue(cls.getNameIndex(), cp);
                }
                case 6: {
                    ConstantDouble dbl = (ConstantDouble)type;
                    return String.valueOf(dbl.getBytes());
                }
                case 9: {
                    ConstantFieldref fieldRef = (ConstantFieldref)type;
                    return ClassFile.constantValue(fieldRef.getClassIndex(), cp) + " " + ClassFile.constantValue(fieldRef.getNameAndTypeIndex(), cp);
                }
                case 4: {
                    ConstantFloat flt = (ConstantFloat)type;
                    return String.valueOf(flt.getBytes());
                }
                case 3: {
                    ConstantInteger integer = (ConstantInteger)type;
                    return String.valueOf(integer.getBytes());
                }
                case 11: {
                    ConstantInterfaceMethodref intRef = (ConstantInterfaceMethodref)type;
                    return ClassFile.constantValue(intRef.getClassIndex(), cp) + " " + ClassFile.constantValue(intRef.getNameAndTypeIndex(), cp);
                }
                case 5: {
                    ConstantLong lng = (ConstantLong)type;
                    return String.valueOf(lng.getBytes());
                }
                case 10: {
                    ConstantMethodref methRef = (ConstantMethodref)type;
                    return ClassFile.constantValue(methRef.getClassIndex(), cp) + " " + ClassFile.constantValue(methRef.getNameAndTypeIndex(), cp);
                }
                case 12: {
                    ConstantNameAndType nameType = (ConstantNameAndType)type;
                    return nameType.getName(cp) + " " + nameType.getSignature(cp);
                }
                case 8: {
                    ConstantString str = (ConstantString)type;
                    return str.getBytes(cp);
                }
                case 1: {
                    ConstantUtf8 utf8 = (ConstantUtf8)type;
                    return utf8.getBytes();
                }
            }
        }
        return "";
    }

    public static String formatBytecode(ByteSequence bytes, ConstantPool cp) throws IOException {
        StringBuilder buf = new StringBuilder();
        boolean wide = false;
        block18: while (bytes.available() > 0) {
            int i;
            short opcode = (short)bytes.readUnsignedByte();
            buf.append(opcode);
            switch (opcode) {
                case 170: {
                    int pad = 0;
                    int rem = bytes.getIndex() % 4;
                    if (rem != 0) {
                        pad = 4 - rem;
                    }
                    for (i = 0; i < pad; ++i) {
                        buf.append(bytes.readByte());
                    }
                    int def = bytes.readInt();
                    buf.append(def);
                    int low = bytes.readInt();
                    buf.append(low);
                    int hi = bytes.readInt();
                    buf.append(hi);
                    for (i = 0; i < hi - low + 1; ++i) {
                        buf.append(bytes.readInt());
                    }
                    continue block18;
                }
                case 171: {
                    int pad = 0;
                    int rem = bytes.getIndex() % 4;
                    if (rem != 0) {
                        pad = 4 - rem;
                    }
                    for (i = 0; i < pad; ++i) {
                        buf.append(bytes.readByte());
                    }
                    int def = bytes.readInt();
                    buf.append(def);
                    int npair = bytes.readInt();
                    buf.append(npair);
                    for (i = 0; i < npair; ++i) {
                        buf.append(bytes.readInt());
                        buf.append(bytes.readInt());
                    }
                    continue block18;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    buf.append(bytes.readShort());
                    continue block18;
                }
                case 200: 
                case 201: {
                    buf.append(bytes.readInt());
                    continue block18;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    if (wide) {
                        buf.append(bytes.readUnsignedShort());
                        wide = false;
                        continue block18;
                    }
                    buf.append(bytes.readUnsignedByte());
                    continue block18;
                }
                case 196: {
                    wide = true;
                    continue block18;
                }
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    int index = bytes.readUnsignedShort();
                    buf.append(ClassFile.constantValue(index, cp));
                    continue block18;
                }
                case 18: {
                    int index = bytes.readUnsignedByte();
                    buf.append(ClassFile.constantValue(index, cp));
                    continue block18;
                }
                case 197: {
                    int index = bytes.readUnsignedShort();
                    buf.append(ClassFile.constantValue(index, cp));
                    buf.append(bytes.readUnsignedByte());
                    continue block18;
                }
                case 132: {
                    if (wide) {
                        buf.append(bytes.readUnsignedShort());
                        buf.append(bytes.readShort());
                        continue block18;
                    }
                    buf.append(bytes.readUnsignedByte());
                    buf.append(bytes.readByte());
                    continue block18;
                }
                case 185: {
                    int index = bytes.readUnsignedShort();
                    buf.append(ClassFile.constantValue(index, cp));
                    buf.append(bytes.readUnsignedByte());
                    buf.append(bytes.readUnsignedByte());
                    continue block18;
                }
            }
            if (Constants.NO_OF_OPERANDS[opcode] <= 0) continue;
            block23: for (i = 0; i < Constants.TYPE_OF_OPERANDS[opcode].length; ++i) {
                switch (Constants.TYPE_OF_OPERANDS[opcode][i]) {
                    case 8: {
                        buf.append(bytes.readUnsignedByte());
                        continue block23;
                    }
                    case 9: {
                        buf.append(bytes.readUnsignedByte());
                        buf.append(bytes.readUnsignedByte());
                        continue block23;
                    }
                    case 10: {
                        buf.append(bytes.readUnsignedByte());
                        buf.append(bytes.readUnsignedByte());
                        buf.append(bytes.readUnsignedByte());
                        buf.append(bytes.readUnsignedByte());
                        continue block23;
                    }
                }
            }
        }
        return buf.toString();
    }

    public static byte[] normalize(byte[] bytes, String fileName) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ClassParser parser = new ClassParser((InputStream)is, fileName);
        StringBuffer buf = new StringBuffer();
        JavaClass klass = parser.parse();
        ConstantPool cpool = klass.getConstantPool();
        buf.append(klass.getSourceFileName());
        buf.append(String.valueOf(klass.getAccessFlags()));
        buf.append(ClassFile.constantValue(klass.getClassNameIndex(), cpool));
        buf.append(ClassFile.constantValue(klass.getSuperclassNameIndex(), cpool));
        for (int index : klass.getInterfaceIndices()) {
            buf.append(ClassFile.constantValue(index, cpool));
        }
        for (Field f : klass.getFields()) {
            buf.append(String.valueOf(f.getAccessFlags()));
            buf.append(ClassFile.constantValue(f.getNameIndex(), cpool));
            buf.append(ClassFile.constantValue(f.getSignatureIndex(), cpool));
            if (f.getConstantValue() == null) continue;
            int index = f.getConstantValue().getConstantValueIndex();
            buf.append(ClassFile.constantValue(index, klass.getConstantPool()));
        }
        for (Method m : klass.getMethods()) {
            buf.append(String.valueOf(m.getAccessFlags()));
            buf.append(ClassFile.constantValue(m.getNameIndex(), cpool));
            buf.append(ClassFile.constantValue(m.getSignatureIndex(), cpool));
            Code code = m.getCode();
            if (code == null) continue;
            ByteSequence bytecode = new ByteSequence(code.getCode());
            buf.append(ClassFile.formatBytecode(bytecode, cpool));
        }
        return buf.toString().getBytes(VictimsConfig.charset());
    }
}

