/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.stax;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import junit.framework.TestCase;

public class InscopeNamespaceTest
extends TestCase {
    public InscopeNamespaceTest(String testName) {
        super(testName);
    }

    public void testXMLStreamBuffer() throws Exception {
        String requestStr = "<S:Header xmlns:user='http://foo.bar' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><user:foo>bar</user:foo></S:Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo.bar", (String)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer1() throws Exception {
        String requestStr = "<S:Header xmlns:user='http://foo.bar' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><user:foo xmlns:user='http://foo.bar'>bar</user:foo></S:Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo.bar", (String)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer2() throws Exception {
        String requestStr = "<S:Header xmlns:user='http://foo.bar' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><user:foo xmlns:user='http://foo1.bar1'>bar</user:foo></S:Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo1.bar1", (String)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer3() throws Exception {
        String requestStr = "<Header xmlns='http://foo.bar' ><user>bar</user><Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo.bar", (String)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer4() throws Exception {
        String requestStr = "<Header xmlns='http://foo.bar' ><user xmlns='http://foo1.bar1'>bar</user><Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo1.bar1", (String)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer5() throws Exception {
        String requestStr = "<S:Header  xmlns:user1='http://foo1.bar1' xmlns:user='http://foo.bar' xmlns:S='http://schemas.xmlsoap.org/soap/envelope/'><user:foo user1:att='value'>bar</user:foo></S:Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo.bar", (String)reader2.getNamespaceURI());
        InscopeNamespaceTest.assertEquals((String)"value", (String)reader2.getAttributeValue("http://foo1.bar1", "att"));
    }

    public void testXMLStreamBuffer6() throws Exception {
        String requestStr = "<Header xmlns='http://foo.bar' ><user xmlns=''>bar</user><Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertNull((Object)reader2.getNamespaceURI());
    }

    public void testXMLStreamBuffer7() throws Exception {
        String requestStr = "<Header xmlns='' ><user xmlns='http://foo.bar'>bar</user><Header>";
        XMLStreamReader reader2 = this.getReader(requestStr);
        reader2.next();
        InscopeNamespaceTest.assertEquals((String)"http://foo.bar", (String)reader2.getNamespaceURI());
    }

    private XMLStreamReader getReader(String requestStr) throws Exception {
        XMLStreamReader reader = this.createXMLStreamReader(new ByteArrayInputStream(requestStr.getBytes()));
        reader.next();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        do {
            reader.next();
        } while (reader.getEventType() != 1);
        MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
        StreamReaderBufferCreator creator = new StreamReaderBufferCreator();
        creator.setXMLStreamBuffer(buffer);
        XMLStreamBufferMark mark = new XMLStreamBufferMark(namespaces, creator);
        creator.createElementFragment(reader, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = this.createXMLStreamWriter(baos);
        writer.writeStartDocument();
        if (mark.getInscopeNamespaces().size() > 0) {
            mark.writeToXMLStreamWriter(writer, true);
        } else {
            mark.writeToXMLStreamWriter(writer);
        }
        writer.writeEndDocument();
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return this.createXMLStreamReader(bais);
    }

    private XMLStreamReader createXMLStreamReader(InputStream is) throws Exception {
        XMLInputFactory readerFactory = XMLInputFactory.newInstance();
        return readerFactory.createXMLStreamReader(is);
    }

    private XMLStreamWriter createXMLStreamWriter(OutputStream os) throws Exception {
        XMLOutputFactory writerFactory = XMLOutputFactory.newInstance();
        return writerFactory.createXMLStreamWriter(os);
    }
}

