/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.logback;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.logback.classic.NDC;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackLoggingAdapter {
    public LoggingEvent convert(ILoggingEvent event, boolean inSameThread) {
        if (event == null) {
            return null;
        }
        LoggingEvent result = new LoggingEvent();
        String messagePattern = event.getMessage();
        Object[] originalArguments = event.getArgumentArray();
        MessageFormatter.ArgumentResult argumentResult = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])originalArguments);
        String[] arguments = null;
        if (argumentResult != null) {
            arguments = argumentResult.getArguments();
            Throwable t = argumentResult.getThrowable();
            if (t != null && event.getThrowableProxy() == null && event instanceof ch.qos.logback.classic.spi.LoggingEvent) {
                ch.qos.logback.classic.spi.LoggingEvent le = (ch.qos.logback.classic.spi.LoggingEvent)event;
                le.setThrowableProxy(new ThrowableProxy(t));
            }
        }
        if (messagePattern != null || arguments != null) {
            Message message = new Message(messagePattern, arguments);
            result.setMessage(message);
        }
        event.prepareForDeferredProcessing();
        result.setThrowable(this.initFromThrowableProxy(event.getThrowableProxy(), true));
        result.setCallStack(this.convert(event.getCallerData()));
        result.setLogger(event.getLoggerName());
        result.setLevel(LoggingEvent.Level.valueOf((String)event.getLevel().toString()));
        LoggerContextVO lcv = event.getLoggerContextVO();
        if (lcv != null) {
            String name = lcv.getName();
            HashMap props = lcv.getPropertyMap();
            if (props != null) {
                props = new HashMap(props);
            }
            LoggerContext loggerContext = new LoggerContext();
            loggerContext.setName(name);
            loggerContext.setProperties(props);
            loggerContext.setBirthTime(Long.valueOf(lcv.getBirthTime()));
            result.setLoggerContext(loggerContext);
        }
        this.initMarker(event, result);
        result.setMdc(event.getMDCPropertyMap());
        String threadName = event.getThreadName();
        if (threadName != null) {
            Long threadId = null;
            String threadGroupName = null;
            Long threadGroupId = null;
            if (inSameThread) {
                Thread t = Thread.currentThread();
                threadId = t.getId();
                ThreadGroup tg = t.getThreadGroup();
                if (tg != null) {
                    threadGroupName = tg.getName();
                    threadGroupId = System.identityHashCode(tg);
                }
            }
            ThreadInfo threadInfo = new ThreadInfo(threadId, threadName, threadGroupId, threadGroupName);
            result.setThreadInfo(threadInfo);
        }
        result.setTimeStamp(Long.valueOf(event.getTimeStamp()));
        if (inSameThread && !NDC.isEmpty()) {
            result.setNdc(NDC.getContextStack());
        }
        return result;
    }

    private ExtendedStackTraceElement[] convert(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new ExtendedStackTraceElement(stackTrace[i]);
        }
        return result;
    }

    ThrowableInfo initFromThrowableProxy(IThrowableProxy ti, boolean calculatePackagingData) {
        if (ti == null) {
            return null;
        }
        ThrowableInfo result = new ThrowableInfo();
        result.setName(ti.getClassName());
        result.setOmittedElements(ti.getCommonFrames());
        result.setMessage(ti.getMessage());
        result.setStackTrace(this.initFromStackTraceElementProxyArray(ti.getStackTraceElementProxyArray()));
        result.setCause(this.initFromThrowableProxy(ti.getCause(), calculatePackagingData));
        return result;
    }

    private ExtendedStackTraceElement[] initFromStackTraceElementProxyArray(StackTraceElementProxy[] stackTraceElementProxies) {
        if (stackTraceElementProxies == null) {
            return null;
        }
        int elementCount = stackTraceElementProxies.length;
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            StackTraceElementProxy currentInput = stackTraceElementProxies[i];
            if (currentInput == null) continue;
            ExtendedStackTraceElement current = new ExtendedStackTraceElement(currentInput.getStackTraceElement());
            ClassPackagingData cpd = currentInput.getClassPackagingData();
            if (cpd != null) {
                current.setCodeLocation(cpd.getCodeLocation());
                current.setExact(cpd.isExact());
                current.setVersion(cpd.getVersion());
            }
            result[i] = current;
        }
        return result;
    }

    private void initMarker(ILoggingEvent src, LoggingEvent dst) {
        org.slf4j.Marker origMarker = src.getMarker();
        if (origMarker == null) {
            return;
        }
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        dst.setMarker(this.initMarkerRecursive(origMarker, markers));
    }

    private Marker initMarkerRecursive(org.slf4j.Marker origMarker, Map<String, Marker> markers) {
        if (origMarker == null) {
            return null;
        }
        String name = origMarker.getName();
        if (markers.containsKey(name)) {
            return markers.get(name);
        }
        Marker newMarker = new Marker(name);
        markers.put(name, newMarker);
        if (origMarker.hasReferences()) {
            for (org.slf4j.Marker current : origMarker) {
                newMarker.add(this.initMarkerRecursive(current, markers));
            }
        }
        return newMarker;
    }
}

