/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler.reporting;

import fr.jcgay.maven.profiler.reporting.ReportFormat;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.project.MavenProject;

public class ReportDirectory {
    private final File directory;

    public ReportDirectory(MavenProject project) {
        this.directory = new File(project.getBasedir(), ".profiler");
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException("Cannot create file to write profiler report: " + this.directory);
        }
    }

    public File fileName(Date date, ReportFormat format) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(date);
        return new File(this.directory, "profiler-report-" + formattedDate + "." + format.extension());
    }
}

