/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;

class Wsdl4jProcessor {
    Wsdl4jProcessor() {
    }

    @BuildStep
    void httpProxies(BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPOperation"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPBody"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPHeader"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPAddress"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPBinding"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPFault"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.wsdl.extensions.soap.SOAPHeaderFault"}));
    }

    @BuildStep
    void reflectiveClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Stream.of("12", "").map(version -> new ReflectiveClassBuildItem(true, false, new String[]{"com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "AddressImpl", "com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "BindingImpl", "com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "BodyImpl", "com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "FaultImpl", "com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "HeaderImpl", "com.ibm.wsdl.extensions.soap" + version + ".SOAP" + version + "OperationImpl"})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"com.ibm.wsdl.extensions.schema.SchemaImpl"}));
    }

    @BuildStep
    void serviceProviders(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        Stream.of("javax.wsdl.factory.WSDLFactory").forEach(serviceName -> {
            try {
                Set<String> names = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + serviceName));
                if (names.isEmpty()) {
                    names = Collections.singleton("com.ibm.wsdl.factory.WSDLFactoryImpl");
                }
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(serviceName, new ArrayList<String>(names)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

