/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.auth;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;

public class AuthFaultOutInterceptor
extends AbstractSoapInterceptor {
    public AuthFaultOutInterceptor() {
        super("post-logical");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Exception e = (Exception)message.getContent(Exception.class);
        if (e instanceof Fault) {
            Throwable securityException = AuthFaultOutInterceptor.rootCause(e);
            if (securityException instanceof UnauthorizedException) {
                ((Fault)e).setStatusCode(401);
            } else if (securityException instanceof ForbiddenException) {
                ((Fault)e).setStatusCode(403);
            }
        }
    }

    private static Throwable rootCause(Exception e) {
        Throwable result = e;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }
}

