/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BeanResolverImpl;
import java.util.Collections;
import java.util.List;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

class DelegateInjectionPointResolverImpl
extends BeanResolverImpl {
    DelegateInjectionPointResolverImpl(BeanDeployment deployment) {
        super(deployment);
    }

    @Override
    boolean parametersMatch(Type delegateType, Type beanParameter) {
        if (DelegateInjectionPointResolverImpl.isActualType(delegateType) && DelegateInjectionPointResolverImpl.isActualType(beanParameter)) {
            return this.matches(delegateType, beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)delegateType.kind()) && DelegateInjectionPointResolverImpl.isActualType(beanParameter)) {
            return this.parametersMatch(delegateType.asWildcardType(), beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)delegateType.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(delegateType.asWildcardType(), beanParameter.asTypeVariable());
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)delegateType.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(delegateType.asTypeVariable(), beanParameter.asTypeVariable());
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)delegateType.kind()) && DelegateInjectionPointResolverImpl.isActualType(beanParameter)) {
            return this.parametersMatch(delegateType.asTypeVariable(), beanParameter);
        }
        return false;
    }

    @Override
    boolean parametersMatch(WildcardType requiredParameter, TypeVariable beanParameter) {
        List<Type> beanParameterBounds = this.getUppermostTypeVariableBounds(beanParameter);
        if (!this.lowerBoundsOfWildcardMatch(beanParameterBounds, requiredParameter)) {
            return false;
        }
        List<Type> requiredUpperBounds = Collections.singletonList(requiredParameter.extendsBound());
        return this.boundsMatch(requiredUpperBounds, beanParameterBounds);
    }

    @Override
    boolean parametersMatch(TypeVariable requiredParameter, TypeVariable beanParameter) {
        return this.boundsMatch(this.getUppermostTypeVariableBounds(requiredParameter), this.getUppermostTypeVariableBounds(beanParameter));
    }

    protected boolean parametersMatch(TypeVariable delegateParameter, Type beanParameter) {
        for (Type type : this.getUppermostTypeVariableBounds(delegateParameter)) {
            if (this.beanDeployment.getAssignabilityCheck().isAssignableFrom(type, beanParameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BeanResolver getBeanResolver(BeanInfo bean) {
        return bean.getDeployment().delegateInjectionPointResolver;
    }
}

