/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.AppCDSContainerImageBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSRequestedBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.JavaVersionUtil;
import io.quarkus.utilities.JavaBinFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class AppCDSBuildStep {
    private static final Logger log = Logger.getLogger(AppCDSBuildStep.class);
    public static final String CLASSES_LIST_FILE_NAME = "classes.lst";
    private static final String CONTAINER_IMAGE_BASE_BUILD_DIR = "/tmp/quarkus";
    private static final String CONTAINER_IMAGE_APPCDS_DIR = "/tmp/quarkus/appcds";
    private static final File NULL_FILE = new File(SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null");

    @BuildStep(onlyIf={AppCDSRequired.class})
    public void requested(OutputTargetBuildItem outputTarget, BuildProducer<AppCDSRequestedBuildItem> producer) throws IOException {
        Path appCDSDir = outputTarget.getOutputDirectory().resolve("appcds");
        IoUtils.createOrEmptyDir((Path)appCDSDir);
        producer.produce(new AppCDSRequestedBuildItem(outputTarget.getOutputDirectory().resolve("appcds")));
    }

    @BuildStep
    public void build(Optional<AppCDSRequestedBuildItem> appCDsRequested, JarBuildItem jarResult, OutputTargetBuildItem outputTarget, PackageConfig packageConfig, Optional<AppCDSContainerImageBuildItem> appCDSContainerImage, BuildProducer<AppCDSResultBuildItem> appCDS, BuildProducer<ArtifactResultBuildItem> artifactResult) throws Exception {
        if (!appCDsRequested.isPresent()) {
            return;
        }
        String containerImage = this.determineContainerImage(packageConfig, appCDSContainerImage);
        String javaBinPath = null;
        if (containerImage == null && !new File(javaBinPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + JavaBinFinder.simpleBinaryName()).canExecute()) {
            log.warnf("In order to create AppCDS the JDK used to build the Quarkus application must contain an executable named '%s' in its 'bin' directory.", (Object)javaBinPath);
            return;
        }
        Path classesLstPath = this.createClassesLst(jarResult, outputTarget, javaBinPath, containerImage, appCDsRequested.get().getAppCDSDir(), packageConfig.isFastJar());
        if (classesLstPath == null) {
            return;
        }
        log.debugf("'%s' successfully created.", (Object)CLASSES_LIST_FILE_NAME);
        log.info((Object)"Launching AppCDS creation process.");
        Path appCDSPath = this.createAppCDS(jarResult, outputTarget, javaBinPath, containerImage, classesLstPath, packageConfig.isFastJar());
        if (appCDSPath == null) {
            log.warn((Object)"Unable to create AppCDS.");
            return;
        }
        log.infof("AppCDS successfully created at: '%s'.", (Object)appCDSPath.toAbsolutePath().toString());
        if (containerImage == null) {
            log.infof("To ensure they are loaded properly, run the application jar from its directory and also add the '-XX:SharedArchiveFile=app-cds.jsa' JVM flag.\nMoreover, make sure to use the exact same Java version (%s) to run the application as was used to build it.", (Object)System.getProperty("java.version"));
        }
        appCDS.produce(new AppCDSResultBuildItem(appCDSPath));
        artifactResult.produce(new ArtifactResultBuildItem(appCDSPath, "appCDS", Collections.emptyMap()));
    }

    private String determineContainerImage(PackageConfig packageConfig, Optional<AppCDSContainerImageBuildItem> appCDSContainerImage) {
        if (packageConfig.appcdsBuilderImage.isPresent()) {
            return packageConfig.appcdsBuilderImage.get();
        }
        if (appCDSContainerImage.isPresent()) {
            return appCDSContainerImage.get().getContainerImage();
        }
        return null;
    }

    private Path createClassesLst(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, Path appCDSDir, boolean isFastJar) {
        int exitCode;
        ArrayList<String> command;
        ArrayList<String> commonJavaArgs = new ArrayList<String>(3);
        commonJavaArgs.add("-XX:DumpLoadedClassList=classes.lst");
        commonJavaArgs.add(String.format("-D%s=true", "quarkus.appcds.generate"));
        commonJavaArgs.add("-jar");
        if (containerImage != null) {
            List<String> dockerRunCommand = this.dockerRunCommands(outputTarget, containerImage, CONTAINER_IMAGE_APPCDS_DIR);
            command = new ArrayList(dockerRunCommand.size() + 1 + commonJavaArgs.size());
            command.addAll(dockerRunCommand);
            command.add("java");
            command.addAll(commonJavaArgs);
            if (isFastJar) {
                command.add("/tmp/quarkus/quarkus-app/quarkus-run.jar");
            } else {
                command.add("/tmp/quarkus/" + jarResult.getPath().getFileName().toString());
            }
        } else {
            command = new ArrayList<String>(2 + commonJavaArgs.size());
            command.add(javaBinPath);
            command.addAll(commonJavaArgs);
            if (isFastJar) {
                command.add(jarResult.getLibraryDir().getParent().resolve("quarkus-run.jar").toAbsolutePath().toString());
            } else {
                command.add(jarResult.getPath().toAbsolutePath().toString());
            }
        }
        if (log.isDebugEnabled()) {
            log.debugf("Launching command: '%s' to create 'classes.lst' file.", (Object)String.join((CharSequence)" ", command));
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(appCDSDir.toFile());
            if (log.isDebugEnabled()) {
                processBuilder.inheritIO();
            } else {
                processBuilder.redirectError(NULL_FILE);
                processBuilder.redirectOutput(NULL_FILE);
            }
            exitCode = processBuilder.start().waitFor();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to launch process used to create 'classes.lst'.", (Throwable)e);
            return null;
        }
        if (exitCode != 0) {
            log.debugf("The process that was supposed to create AppCDS exited with error code: %d.", exitCode);
            return null;
        }
        Path result = appCDSDir.resolve(CLASSES_LIST_FILE_NAME);
        if (!Files.exists(result, new LinkOption[0])) {
            log.warnf("Unable to create AppCDS because '%s' was not created. Check the logs for details", (Object)CLASSES_LIST_FILE_NAME);
            return null;
        }
        return result;
    }

    private List<String> dockerRunCommands(OutputTargetBuildItem outputTarget, String containerImage, String containerWorkingDir) {
        ArrayList<String> command = new ArrayList<String>(10);
        command.add("docker");
        command.add("run");
        command.add("-v");
        command.add(outputTarget.getOutputDirectory().toAbsolutePath().toString() + ":" + CONTAINER_IMAGE_BASE_BUILD_DIR + ":z");
        if (SystemUtils.IS_OS_LINUX) {
            String uid = LinuxIDUtil.getLinuxID("-ur");
            String gid = LinuxIDUtil.getLinuxID("-gr");
            if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                command.add("--user");
                command.add(uid + ":" + gid);
            }
        }
        command.add("-w");
        command.add(containerWorkingDir);
        command.add("--rm");
        command.add(containerImage);
        return command;
    }

    private Path createAppCDS(JarBuildItem jarResult, OutputTargetBuildItem outputTarget, String javaBinPath, String containerImage, Path classesLstPath, boolean isFastFar) {
        int exitCode;
        ArrayList<String> command;
        Path workingDirectory = jarResult.getPath().getParent();
        Path appCDSPath = workingDirectory.resolve("app-cds.jsa");
        if (appCDSPath.toFile().exists()) {
            try {
                Files.delete(appCDSPath);
            }
            catch (IOException e) {
                log.debug((Object)"Unable to delete existing 'app-cds.jsa' file.", (Throwable)e);
            }
        }
        ArrayList<String> javaArgs = new ArrayList<String>(5);
        javaArgs.add("-Xshare:dump");
        javaArgs.add("-XX:SharedClassListFile=" + (containerImage != null ? "/tmp/quarkus/appcds/" + classesLstPath.getFileName().toString() : classesLstPath.toAbsolutePath().toString()));
        javaArgs.add("-XX:SharedArchiveFile=" + appCDSPath.getFileName().toString());
        javaArgs.add("--class-path");
        if (isFastFar) {
            javaArgs.add("quarkus-run.jar");
        } else {
            javaArgs.add(jarResult.getPath().getFileName().toString());
        }
        if (containerImage != null) {
            List<String> dockerRunCommand = this.dockerRunCommands(outputTarget, containerImage, "/tmp/quarkus/quarkus-app");
            command = new ArrayList(dockerRunCommand.size() + 1 + javaArgs.size());
            command.addAll(dockerRunCommand);
            command.add("java");
            command.addAll(javaArgs);
        } else {
            command = new ArrayList<String>(1 + javaArgs.size());
            command.add(javaBinPath);
            command.addAll(javaArgs);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Launching command: '%s' to create final AppCDS.", (Object)String.join((CharSequence)" ", command));
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(workingDirectory.toFile());
            if (log.isDebugEnabled()) {
                processBuilder.inheritIO();
            } else {
                processBuilder.redirectError(NULL_FILE);
                processBuilder.redirectOutput(NULL_FILE);
            }
            exitCode = processBuilder.start().waitFor();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to launch process used to create AppCDS.", (Throwable)e);
            return null;
        }
        if (exitCode != 0) {
            log.debugf("The process that was supposed to create AppCDS exited with error code: %d.", exitCode);
            return null;
        }
        if (!appCDSPath.toFile().exists()) {
            return null;
        }
        return appCDSPath;
    }

    static class AppCDSRequired
    implements BooleanSupplier {
        private final PackageConfig packageConfig;
        private final LaunchMode launchMode;

        AppCDSRequired(PackageConfig packageConfig, LaunchMode launchMode) {
            this.packageConfig = packageConfig;
            this.launchMode = launchMode;
        }

        @Override
        public boolean getAsBoolean() {
            if (this.launchMode != LaunchMode.NORMAL) {
                return false;
            }
            if (!this.packageConfig.createAppcds || !this.packageConfig.isAnyJarType()) {
                return false;
            }
            if (!JavaVersionUtil.isJava11OrHigher()) {
                log.warn((Object)"AppCDS can only be used with Java 11+.");
                return false;
            }
            return true;
        }
    }
}

