/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class MongoServiceBindingConverter
implements ServiceBindingConverter {
    private static final Logger LOGGER = Logger.getLogger(MongoServiceBindingConverter.class);
    private static final String BINDING_TYPE = "mongodb";
    public static final String BINDING_CONFIG_SOURCE_NAME = "mongodb-k8s-service-binding-source";
    public static final String MONGO_DB_CONNECTION_STRING = "quarkus.mongodb.connection-string";
    public static final String MONGO_DB_USERNAME = "quarkus.mongodb.credentials.username";
    public static final String MONGO_DB_PASSWORD = "quarkus.mongodb.credentials.password";
    public static final String DB_USER = "username";
    public static final String DB_PASSWORD = "password";
    public static final String DB_HOST = "host";
    public static final String DB_DATABASE = "database";
    public static final String DB_OPTIONS = "options";
    public static final String DB_PREFIX_STANDARD = "mongodb://";
    public static final String DB_PREFIX_SRV = "mongodb+srv://";
    public static final String DB_SRV = "srv";
    private static final String CONNECTION_STRING_WITH_HOST_N_DB = "%s%s/%s";
    private static final String CONNECTION_STRING_WITH_ONLY_HOST = "%s%s";

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)BINDING_TYPE, serviceBindings);
        if (matchingByType.isEmpty()) {
            return Optional.empty();
        }
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.setConnectionString(binding, properties);
        this.setUsername(binding, properties);
        this.setPassword(binding, properties);
        return Optional.of(new ServiceBindingConfigSource(BINDING_CONFIG_SOURCE_NAME, properties));
    }

    private void setConnectionString(ServiceBinding binding, Map<String, String> properties) {
        Object connectionString;
        String hostPort = this.getHost(binding);
        String prefix = this.isSrv(binding) ? DB_PREFIX_SRV : DB_PREFIX_STANDARD;
        String database = this.getDbProperty(binding, DB_DATABASE);
        String options = this.getDbProperty(binding, DB_OPTIONS);
        boolean isOptionsNotBlank = this.isNotBlank(options);
        if (this.isBlank(database)) {
            connectionString = String.format(CONNECTION_STRING_WITH_ONLY_HOST, prefix, hostPort);
            if (isOptionsNotBlank) {
                connectionString = (String)connectionString + "/";
            }
        } else {
            connectionString = String.format(CONNECTION_STRING_WITH_HOST_N_DB, prefix, hostPort, database);
        }
        if (isOptionsNotBlank) {
            connectionString = (String)connectionString + "?" + options;
        }
        LOGGER.debug((Object)String.format("MongoDB connection string: [%s]", connectionString));
        properties.put(MONGO_DB_CONNECTION_STRING, (String)connectionString);
    }

    private void setUsername(ServiceBinding binding, Map<String, String> properties) {
        String username = this.getDbProperty(binding, DB_USER);
        LOGGER.debug((Object)String.format("MongoDB username=%s", username));
        properties.put(MONGO_DB_USERNAME, username);
    }

    private void setPassword(ServiceBinding binding, Map<String, String> properties) {
        properties.put(MONGO_DB_PASSWORD, this.getDbProperty(binding, DB_PASSWORD));
    }

    private String getDbProperty(ServiceBinding binding, String dbPropertyKey) {
        String dbPropertyValue = (String)binding.getProperties().get(dbPropertyKey);
        if (this.isBlank(dbPropertyValue)) {
            LOGGER.debug((Object)String.format("Property '%s' not found", dbPropertyKey));
        }
        return dbPropertyValue;
    }

    private String getHost(ServiceBinding binding) {
        String host = this.getDbProperty(binding, DB_HOST);
        if (this.isBlank(host)) {
            LOGGER.warn((Object)"Unable to get the host property. Connection string won't be correct");
        }
        return host;
    }

    private boolean isSrv(ServiceBinding binding) {
        String srv = this.getDbProperty(binding, DB_SRV);
        return this.isNotBlank(srv) && Boolean.parseBoolean(srv);
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    private boolean isNotBlank(String value) {
        return !this.isBlank(value);
    }
}

