/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.handlers.RedirectHandler;

public class WrapperVertxRedirectHandlerImpl
implements Function<HttpClientResponse, Future<RequestOptions>> {
    private final RedirectHandler actualHandler;

    public WrapperVertxRedirectHandlerImpl(RedirectHandler actualHandler) {
        this.actualHandler = actualHandler;
    }

    @Override
    public Future<RequestOptions> apply(HttpClientResponse httpClientResponse) {
        Response.ResponseBuilder response = Response.status((int)httpClientResponse.statusCode());
        for (String headerName : httpClientResponse.headers().names()) {
            response.header(headerName, (Object)httpClientResponse.headers().get(headerName));
        }
        URI newLocation = this.actualHandler.handle(response.build());
        if (newLocation != null) {
            RequestOptions options = new RequestOptions();
            options.setAbsoluteURI(newLocation.toString());
            return Future.succeededFuture((Object)options);
        }
        return null;
    }
}

