/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.util.function.Function;
import org.jboss.jandex.GenericSignature;
import org.jboss.jandex.Type;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmUtil {
    public static String getSignature(org.jboss.jandex.Type type) {
        StringBuilder result = new StringBuilder();
        GenericSignature.forType((org.jboss.jandex.Type)type, (Function)GenericSignature.NO_SUBSTITUTION, (StringBuilder)result);
        return result.toString();
    }

    public static String getSignature(org.jboss.jandex.Type type, Function<String, org.jboss.jandex.Type> typeVariableSubstitution) {
        StringBuilder result = new StringBuilder();
        GenericSignature.forType((org.jboss.jandex.Type)type, typeVariableSubstitution, (StringBuilder)result);
        return result.toString();
    }

    public static void unboxIfRequired(MethodVisitor mv, org.jboss.jandex.Type jandexType) {
        if (jandexType.kind() == Type.Kind.PRIMITIVE) {
            switch (jandexType.asPrimitiveType().primitive()) {
                case BOOLEAN: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case BYTE: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case CHAR: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case DOUBLE: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case FLOAT: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case INT: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case LONG: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case SHORT: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown primitive type: " + jandexType);
                }
            }
        }
    }

    public static void unboxIfRequired(MethodVisitor mv, Type type) {
        if (type.getSort() <= 8) {
            switch (type.getSort()) {
                case 1: {
                    AsmUtil.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                    break;
                }
                case 3: {
                    AsmUtil.unbox(mv, "java/lang/Byte", "byteValue", "B");
                    break;
                }
                case 2: {
                    AsmUtil.unbox(mv, "java/lang/Character", "charValue", "C");
                    break;
                }
                case 8: {
                    AsmUtil.unbox(mv, "java/lang/Double", "doubleValue", "D");
                    break;
                }
                case 6: {
                    AsmUtil.unbox(mv, "java/lang/Float", "floatValue", "F");
                    break;
                }
                case 5: {
                    AsmUtil.unbox(mv, "java/lang/Integer", "intValue", "I");
                    break;
                }
                case 7: {
                    AsmUtil.unbox(mv, "java/lang/Long", "longValue", "J");
                    break;
                }
                case 4: {
                    AsmUtil.unbox(mv, "java/lang/Short", "shortValue", "S");
                }
            }
        }
    }

    private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
        mv.visitTypeInsn(192, owner);
        mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
    }
}

