/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.headers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;

public class LinkHeaders {
    private final Map<String, Link> linksByRelationship = new HashMap<String, Link>();
    private final List<Link> links = new ArrayList<Link>();

    public LinkHeaders(MultivaluedMap<String, Object> headers) {
        List values = (List)headers.get((Object)"Link");
        if (values == null) {
            return;
        }
        for (Object val : values) {
            if (val instanceof Link) {
                this.addLink((Link)val);
                continue;
            }
            if (val instanceof String) {
                for (String link : ((String)val).split(",")) {
                    this.addLink(Link.valueOf((String)link));
                }
                continue;
            }
            String str = HeaderUtil.headerToString(val);
            this.addLink(Link.valueOf((String)str));
        }
    }

    private void addLink(Link link) {
        this.links.add(link);
        for (String rel : link.getRels()) {
            this.linksByRelationship.put(rel, link);
        }
    }

    public Link getLinkByRelationship(String rel) {
        return this.linksByRelationship.get(rel);
    }

    public List<Link> getLinks() {
        return this.links;
    }
}

